/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.app.service;

import fr.cnav.saturne.app.service.FolderWatcher;
import fr.cnav.saturne.app.service.ValidationJob;
import fr.cnav.saturne.app.service.exception.ExceptionKind;
import fr.cnav.saturne.app.service.exception.ValidationServiceException;
import fr.cnav.saturne.app.service.handlers.DSNToReportHandler;
import fr.cnav.saturne.app.service.helpers.LoggerHelper;
import fr.cnav.saturne.app.service.helpers.Messages;
import fr.cnav.saturne.app.service.helpers.SystemFileHelper;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;

public class ValidationServiceJava {
    public static final String INPUT_FORMAT_PARAMETER = "-inputFileType";
    public static final String XML_INPUT_FORMAT_PARAMETER = "-inputFileTypeXML";
    public static final LoggerHelper LOGGER = new LoggerHelper(ValidationServiceJava.class);
    private static final Properties SYS_PROP = System.getProperties();
    private static final int DEFAULT_EXECUTION_THREAD_NUMBER = 3;
    private static final int SEVEN = 7;
    private int executionThreadNumber = 3;
    private boolean isTempRunningFile;
    private File validationReportRootPath;
    private boolean isTempValidationReportRootPath;
    private File convertedFilestRootPath;
    private boolean isTempConvertedFilestRootPath;
    private File inputDirFile;
    private File outputDirFile;
    private File runningFile;
    private String extFilter = ".*";
    private BlockingQueue<File> inputFileQueue;

    public ValidationServiceJava(String[] args) throws IOException, InterruptedException {
        LOGGER.logConsoleInfoPrefix(Messages.LOG_RUNNING_2, "=> ");
        this.validateParameters(args);
        this.initSysProperties();
        this.initIntegrationPaths();
        LOGGER.logConsoleInfo(Messages.LOG_RUNNING_3, this.inputDirFile.getAbsolutePath());
        LOGGER.logConsoleInfo(Messages.LOG_RUNNING_4, this.outputDirFile.getAbsolutePath());
        LOGGER.logConsoleInfo(Messages.LOG_RUNNING_5, new File(".").getAbsolutePath().replace("/.", ""));
        LOGGER.logConsoleInfo(Messages.LOG_RUNNING_6);
        LOGGER.logConsoleInfo(Messages.LOG_RUNNING_7);
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        ValidationServiceJava validationServiceJava = new ValidationServiceJava(args);
        validationServiceJava.start();
    }

    private void validateParameters(String[] args) throws ValidationServiceException {
        if (args.length >= 1 && args[0].equals("-help")) {
            ValidationServiceJava.validationServiceHelp();
            System.exit(ExceptionKind.NEED_HELP.getCode());
        }
        this.validateArgsLength(args);
        String inputDir = args[0];
        this.inputDirFile = new File(inputDir);
        if (!this.inputDirFile.exists()) {
            ValidationServiceJava.validationServiceHelp();
            throw new ValidationServiceException(ExceptionKind.INPUT_DIR_NOT_EXIST, inputDir);
        }
        if (!this.inputDirFile.isDirectory()) {
            ValidationServiceJava.validationServiceHelp();
            throw new ValidationServiceException(ExceptionKind.INPUT_DIR_IS_NOT_A_DIR, this.inputDirFile.getAbsoluteFile());
        }
        if (!this.inputDirFile.canWrite()) {
            ValidationServiceJava.validationServiceHelp();
            throw new ValidationServiceException(ExceptionKind.INPUT_DIR_IS_NOT_WRITEABLE, this.inputDirFile.getAbsoluteFile());
        }
        String outputDir = args[1];
        this.outputDirFile = new File(outputDir);
        if (!this.outputDirFile.exists()) {
            ValidationServiceJava.validationServiceHelp();
            throw new ValidationServiceException(ExceptionKind.OUTPUT_DIR_NOT_EXIST, outputDir);
        }
        if (!this.outputDirFile.isDirectory()) {
            ValidationServiceJava.validationServiceHelp();
            throw new ValidationServiceException(ExceptionKind.OUTPUT_DIR_IS_NOT_A_DIR, this.outputDirFile.getAbsoluteFile());
        }
        if (!this.outputDirFile.canWrite()) {
            ValidationServiceJava.validationServiceHelp();
            throw new ValidationServiceException(ExceptionKind.OUTPUT_DIR_IS_NOT_WRITEABLE, this.outputDirFile.getAbsoluteFile());
        }
        if (args.length > 2) {
            int i = 2;
            while (i != args.length) {
                if ("-ext".equals(args[i])) {
                    this.extFilter = ".*\\." + args[++i];
                } else if ("-threadNbr".equals(args[i])) {
                    this.executionThreadNumber = Integer.parseInt(args[++i]);
                }
                ++i;
            }
        }
    }

    private void validateArgsLength(String[] args) throws ValidationServiceException {
        if (args.length < 1) {
            throw new ValidationServiceException(ExceptionKind.MISSING_ARGUMENTS_ERROR);
        }
        if (args.length < 2) {
            throw new ValidationServiceException(ExceptionKind.WRONG_ARGUMENTS_NUMBER_ERROR_1, args.length);
        }
        if (args.length > 7) {
            throw new ValidationServiceException(ExceptionKind.WRONG_ARGUMENTS_NUMBER_ERROR_2, args.length);
        }
    }

    private void initIntegrationPaths() {
        System.setProperty("input.file.path", this.inputDirFile.getAbsolutePath());
        System.setProperty("validated.folder.path", this.outputDirFile.getAbsolutePath());
        if (!SYS_PROP.containsKey("running.folder.path")) {
            this.runningFile = SystemFileHelper.createTempDirAndInstallHookDeleteOnShutdown();
            this.isTempRunningFile = true;
            System.setProperty("running.folder.path", this.runningFile.getAbsolutePath());
        } else {
            String runningPath = System.getProperty("running.folder.path");
            this.runningFile = new File(runningPath);
            if (!this.runningFile.exists()) {
                throw new ValidationServiceException(ExceptionKind.RUNNING_DIR_NOT_EXIST, runningPath, "running.folder.path");
            }
            if (!this.runningFile.isDirectory()) {
                throw new ValidationServiceException(ExceptionKind.RUNNING_DIR_IS_NOT_A_DIR, this.runningFile.getAbsoluteFile(), "running.folder.path");
            }
            if (!this.runningFile.canWrite()) {
                throw new ValidationServiceException(ExceptionKind.RUNNING_DIR_IS_NOT_WRITEABLE, this.runningFile.getAbsoluteFile(), "running.folder.path");
            }
        }
        System.setProperty("filter.file.ext", this.extFilter);
    }

    private void initSysProperties() {
        if (!SYS_PROP.containsKey("reports.root.path")) {
            this.validationReportRootPath = SystemFileHelper.createTempDirAndInstallHookDeleteOnShutdown();
            this.isTempValidationReportRootPath = true;
            System.setProperty("reports.root.path", this.validationReportRootPath.getAbsolutePath());
        } else {
            File reportFolder = new File(SYS_PROP.getProperty("reports.root.path"));
            if (!reportFolder.exists()) {
                throw new ValidationServiceException(ExceptionKind.RUNNING_DIR_NOT_EXIST, reportFolder, "reports.root.path");
            }
            if (!reportFolder.isDirectory()) {
                throw new ValidationServiceException(ExceptionKind.RUNNING_DIR_IS_NOT_A_DIR, reportFolder, "reports.root.path");
            }
            if (!reportFolder.canWrite()) {
                throw new ValidationServiceException(ExceptionKind.RUNNING_DIR_IS_NOT_WRITEABLE, reportFolder, "reports.root.path");
            }
        }
        System.setProperty("reports.backup.enable", "false");
        if (!SYS_PROP.containsKey("convertedFiles.root.path")) {
            this.convertedFilestRootPath = SystemFileHelper.createTempDirAndInstallHookDeleteOnShutdown();
            this.isTempConvertedFilestRootPath = true;
            System.setProperty("convertedFiles.root.path", this.convertedFilestRootPath.getAbsolutePath());
        } else {
            File converFolder = new File(SYS_PROP.getProperty("convertedFiles.root.path"));
            if (!converFolder.exists()) {
                throw new ValidationServiceException(ExceptionKind.RUNNING_DIR_NOT_EXIST, converFolder, "convertedFiles.root.path");
            }
            if (!converFolder.isDirectory()) {
                throw new ValidationServiceException(ExceptionKind.RUNNING_DIR_IS_NOT_A_DIR, converFolder, "convertedFiles.root.path");
            }
            if (!converFolder.canWrite()) {
                throw new ValidationServiceException(ExceptionKind.RUNNING_DIR_IS_NOT_WRITEABLE, converFolder, "convertedFiles.root.path");
            }
        }
        if (!SYS_PROP.containsKey("spring.poller.fixed.rate")) {
            System.setProperty("spring.poller.fixed.rate", "1000");
        }
        if (!SYS_PROP.containsKey("spring.poller.maxmsgperpoll")) {
            System.setProperty("spring.poller.maxmsgperpoll", "10");
        }
    }

    private void installCleanHookOnShutdown() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                super.run();
                LOGGER.logInfo(Messages.LOG_RUNNING_9);
                LOGGER.logConsoleInfo(Messages.LOG_RUNNING_13);
                while (SystemFileHelper.filterHiddenFiles(ValidationServiceJava.this.runningFile).length != 0) {
                    try {
                        1.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                LOGGER.logConsoleInfo(Messages.LOG_RUNNING_14);
                LOGGER.logInfo(Messages.LOG_RUNNING_10);
                if (ValidationServiceJava.this.isTempRunningFile) {
                    LOGGER.logInfo(Messages.LOG_RUNNING_12, ValidationServiceJava.this.runningFile.getAbsoluteFile());
                    SystemFileHelper.deleteFolder(ValidationServiceJava.this.runningFile);
                }
                if (ValidationServiceJava.this.isTempValidationReportRootPath) {
                    LOGGER.logInfo(Messages.LOG_RUNNING_12, ValidationServiceJava.this.validationReportRootPath.getAbsoluteFile());
                    SystemFileHelper.deleteFolder(ValidationServiceJava.this.validationReportRootPath);
                }
                if (ValidationServiceJava.this.isTempConvertedFilestRootPath) {
                    LOGGER.logInfo(Messages.LOG_RUNNING_12, ValidationServiceJava.this.convertedFilestRootPath.getAbsoluteFile());
                    SystemFileHelper.deleteFolder(ValidationServiceJava.this.convertedFilestRootPath);
                }
                LOGGER.logConsoleInfoPrefix(Messages.LOG_RUNNING_11, "=> ");
            }
        });
    }

    public void start() throws InterruptedException, IOException {
        this.inputFileQueue = new LinkedBlockingQueue<File>();
        this.installCleanHookOnShutdown();
        this.launchWatchFolderThread();
        this.launchValidationThreads();
    }

    private void launchWatchFolderThread() throws IOException {
        if (this.extFilter == null) {
            this.extFilter = ".*";
        }
        Thread thread = new Thread(new FolderWatcher(this.inputDirFile, this.inputFileQueue, this.extFilter));
        thread.start();
    }

    private void launchValidationThreads() throws InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(this.executionThreadNumber);
        DSNToReportHandler dsnToReportHandler = new DSNToReportHandler(this.outputDirFile.getAbsolutePath(), this.runningFile.getAbsolutePath());
        while (true) {
            File currentFileToValidate = this.inputFileQueue.take();
            ValidationJob validationJob = new ValidationJob(dsnToReportHandler, currentFileToValidate);
            executor.submit(validationJob);
        }
    }

    public static void validationServiceHelp() {
        System.out.println(Messages.HELP_LINE_02);
    }
}

