/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.utils;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.BlockRefinement;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.FieldRefinement;
import fr.cnav.saturne.UsageType;

public class RefinementUtil {
    public boolean isRaffined(Field field, FieldRefinement fieldRefinement) {
        boolean result = false;
        if (fieldRefinement != null) {
            if (fieldRefinement.getUsage() != UsageType.UNSET && fieldRefinement.getUsage() != field.getUsage()) {
                result = true;
            } else if (!fieldRefinement.getInhibitedRules().isEmpty()) {
                result = true;
            }
        }
        return result;
    }

    public boolean isRaffined(Block block, BlockRefinement blockRefinement) {
        boolean result = false;
        if (blockRefinement != null) {
            if (blockRefinement.getUsage() != UsageType.UNSET && blockRefinement.getUsage() != block.getUsage()) {
                result = true;
            } else if (blockRefinement.getInhibitedRules() != null && !blockRefinement.getInhibitedRules().isEmpty()) {
                result = true;
            } else if (blockRefinement.getLowerBound() != null && blockRefinement.getLowerBound().getNewBound() != block.getLowerBound()) {
                result = true;
            } else if (blockRefinement.getUpperBound() != null && blockRefinement.getUpperBound().getNewBound() != block.getUpperBound()) {
                result = true;
            }
        }
        return result;
    }

    public Boolean isBlockForbidden(Block block, Declaration declaration) {
        if (declaration.getBlockUpperBound(block) != 0 && declaration.getUsage(block) != UsageType.FORBIDDEN) {
            return false;
        }
        return true;
    }
}

