/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.options;

import fr.cnav.saturne.options.IOptionMapListener;
import fr.cnav.saturne.options.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OptionMap {
    private final Map<String, Object> options = new HashMap<String, Object>();
    private final List<IOptionMapListener> listeners = new ArrayList<IOptionMapListener>();

    public void addListener(IOptionMapListener listener) {
        this.listeners.add(listener);
    }

    public <T> T getOption(Key<T> key) {
        return (T)this.options.get(key.getKeyValue());
    }

    public <T> void setOption(Key<T> key, T value) {
        this.options.put(key.getKeyValue(), value);
        this.notify(key, value);
    }

    private <T> void notify(Key<T> key, T value) {
        for (IOptionMapListener listener : this.listeners) {
            listener.notify(key, value);
        }
    }
}

