/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.types.adapter;

import fr.cnav.saturne.dsl.formules.FieldRef;
import fr.cnav.saturne.dsl.formules.IteratorVariable;
import fr.cnav.saturne.dsl.formules.Quantified;
import fr.cnav.saturne.dsl.parser.Logging;
import fr.cnav.saturne.dsl.types.Type;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapter;
import fr.cnav.saturne.dsl.types.adapter.ITypingEnvironment;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import org.eclipse.emf.ecore.EObject;

public class FieldRefTypeAdapter
extends DSLTypeAdapter {
    @Override
    Type computeType(Type context, Map<String, Type> env) {
        String contextVariableName;
        Optional<String> resolvedVariable;
        assert (this.getTarget() instanceof FieldRef);
        FieldRef fieldRef = (FieldRef)this.getTarget();
        StringBuilder fieldRefID = new StringBuilder();
        fieldRefID.append(fieldRef.getName());
        if (context == Type.NODE) {
            return Type.NODE;
        }
        boolean isMultiple = this.getTypingEnvironement().isMultiple(fieldRef.getName());
        if (fieldRef.getContextVariable() != null && (resolvedVariable = this.resolveVariable(contextVariableName = fieldRef.getContextVariable(), fieldRef.eContainer())).isPresent()) {
            isMultiple = this.getTypingEnvironement().isMultiple(fieldRef.getName(), resolvedVariable.get());
        }
        ITypingEnvironment environment = this.getTypingEnvironement();
        Type result = environment.getNodeType(fieldRefID.toString());
        if (isMultiple) {
            if (result == Type.ALPHANUM) {
                result = Type.ALPHANUM_LIST;
            } else if (result == Type.TOKEN) {
                result = Type.TOKEN_LIST;
            } else if (result == Type.NUM) {
                result = Type.NUM_LIST;
            } else if (result == Type.DATE) {
                result = Type.DATE_LIST;
            } else if (result == Type.NODE) {
                result = Type.NODE_LIST;
            }
        }
        if (result == Type.UNDEFINED) {
            this.setErrorMsg("FieldRef couldn't be found in the models: " + fieldRefID);
            Logging.LOGGER.log(Level.SEVERE, this.getErrorMsg());
        }
        return result;
    }

    private Optional<String> resolveVariable(String variableName, EObject contextExpression) {
        if (contextExpression == null) {
            return Optional.empty();
        }
        if (contextExpression instanceof Quantified) {
            for (IteratorVariable variable : ((Quantified)contextExpression).getVariables()) {
                if (!variable.getVarName().equals(variableName)) continue;
                FieldRef variableElement = variable.getElement();
                return Optional.of(variableElement.getName());
            }
        }
        return this.resolveVariable(variableName, contextExpression.eContainer());
    }
}

