/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.optimization.invariants;

import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.Let;
import fr.cnav.saturne.dsl.formules.Literal;
import fr.cnav.saturne.dsl.formules.Quantified;
import fr.cnav.saturne.dsl.formules.ValueList;
import fr.cnav.saturne.dsl.formules.VarRef;
import fr.cnav.saturne.dsl.formules.util.FormulesSwitch;
import fr.cnav.saturne.dsl.optimization.FreshVariableGenerator;
import fr.cnav.saturne.dsl.optimization.invariants.InvariantDetector;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class InvariantHoisting
extends FormulesSwitch<Boolean> {
    private Map<Expression, Map<String, Expression>> invariantVarNameMap;
    private Map<Expression, String> invariantGlobalExprMap;

    public Map<Expression, Map<String, Expression>> getInvariantVarNameMap() {
        return this.invariantVarNameMap;
    }

    public Map<Expression, String> getInvariantGlobalExprMap() {
        return this.invariantGlobalExprMap;
    }

    public void extractInvariant(Expression formule) {
        this.invariantVarNameMap = new HashMap<Expression, Map<String, Expression>>();
        this.invariantGlobalExprMap = new HashMap<Expression, String>();
        this.doSwitch(formule);
    }

    private boolean allowedHoistingType(EObject expr) {
        boolean result = false;
        if (expr instanceof Literal) {
            result = false;
        } else if (expr instanceof ValueList) {
            result = false;
        } else if (expr instanceof VarRef) {
            result = false;
        } else if (expr instanceof Expression) {
            result = true;
        }
        return result;
    }

    private void hoistingInvariants(Expression concernedExp, Expression exprWhereFindInv, Set<Expression> invariantSet) {
        HashMap<String, Expression> varMap = new HashMap<String, Expression>();
        TreeIterator treeIterator = exprWhereFindInv.eAllContents();
        while (treeIterator.hasNext()) {
            Expression curExp;
            EObject curEObj = (EObject)treeIterator.next();
            if (!invariantSet.contains(curEObj)) continue;
            if (this.allowedHoistingType(curEObj) && curEObj instanceof Expression && !this.invariantGlobalExprMap.containsKey(curExp = (Expression)curEObj)) {
                String letVar = FreshVariableGenerator.getFreshVariable();
                this.invariantGlobalExprMap.put(curExp, letVar);
                Expression curExpCopy = (Expression)new EcoreUtil.Copier().copy((EObject)curExp);
                varMap.put(letVar, curExpCopy);
            }
            treeIterator.prune();
        }
        this.invariantVarNameMap.put(concernedExp, varMap);
    }

    @Override
    public Boolean caseExpression(Expression input) {
        for (EObject eObject : input.eContents()) {
            this.doSwitch(eObject);
        }
        return true;
    }

    @Override
    public Boolean caseQuantified(Quantified input) {
        InvariantDetector invariantDetector = new InvariantDetector();
        Set<Expression> invariantSet = invariantDetector.getInvariants(input);
        Expression exprWhereFindInv = input.getExpression();
        this.hoistingInvariants(input, exprWhereFindInv, invariantSet);
        this.doSwitch(input.getExpression());
        return true;
    }

    @Override
    public Boolean caseLet(Let input) {
        InvariantDetector invariantDetector = new InvariantDetector();
        Set<Expression> invariantSet = invariantDetector.getInvariants(input);
        Expression exprWhereFindInv = input.getIn();
        this.hoistingInvariants(input, exprWhereFindInv, invariantSet);
        this.doSwitch(input.getIn());
        return true;
    }

    @Override
    public Boolean caseLiteral(Literal input) {
        return true;
    }

    @Override
    public Boolean defaultCase(EObject object) {
        return true;
    }
}

