/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.ui.proxy;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ReflectUtil {
    private ReflectUtil() {
    }

    public static <T> Constructor<T> getConstructor(Class<T> c, Class<?> ... parameterTypes) {
        try {
            Constructor<T> constructor = c.getDeclaredConstructor(parameterTypes);
            ReflectUtil.makeAccessible(constructor);
            return constructor;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ReflectionException(ex);
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... arguments) {
        try {
            return constructor.newInstance(arguments);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause != null && "org.eclipse.core.runtime.OperationCanceledException".equals(cause.getClass().getName())) {
                throw (RuntimeException)cause;
            }
            throw new ReflectionException(cause);
        }
        catch (Exception ex) {
            throw new ReflectionException(ex);
        }
    }

    public static Method getMethod(Class<?> c, String methodName, Class<?> ... parameterTypes) {
        try {
            try {
                Method method = c.getDeclaredMethod(methodName, parameterTypes);
                ReflectUtil.makeAccessible(method);
                return method;
            }
            catch (NoSuchMethodException ex) {
                Class<?> superclass = c.getSuperclass();
                if (superclass != null) {
                    return ReflectUtil.getMethod(superclass, methodName, parameterTypes);
                }
                throw ex;
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ReflectionException(ex);
        }
    }

    public static Object invokeMethod(Method method, Object target, Object ... arguments) {
        try {
            return method.invoke(target, arguments);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause != null && "org.eclipse.core.runtime.OperationCanceledException".equals(cause.getClass().getName())) {
                throw (RuntimeException)cause;
            }
            throw new ReflectionException(cause);
        }
        catch (Exception ex) {
            throw new ReflectionException(ex);
        }
    }

    public static Field getField(Class<?> c, String fieldName) {
        try {
            try {
                Field field = c.getDeclaredField(fieldName);
                ReflectUtil.makeAccessible(field);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Class<?> superclass = c.getSuperclass();
                if (superclass != null) {
                    return ReflectUtil.getField(superclass, fieldName);
                }
                return null;
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ReflectionException(ex);
        }
    }

    public static Object getValue(Field field, Object target) {
        try {
            return field.get(target);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ReflectionException(ex);
        }
    }

    public static void setValue(Field field, Object target, Object value) {
        ReflectUtil.setValue(field, target, value, false);
    }

    public static void setValue(Field field, Object target, Object value, boolean force) {
        try {
            Class<?> type;
            if ((field.getModifiers() & 0x10) != 0 && force) {
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                ReflectUtil.makeAccessible(modifiersField);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            if ((type = field.getType()).isPrimitive()) {
                if (Boolean.TYPE == type) {
                    field.setBoolean(target, (Boolean)value);
                } else if (Character.TYPE == type) {
                    field.setChar(target, ((Character)value).charValue());
                } else if (Byte.TYPE == type) {
                    field.setByte(target, (Byte)value);
                } else if (Short.TYPE == type) {
                    field.setShort(target, (Short)value);
                } else if (Integer.TYPE == type) {
                    field.setInt(target, (Integer)value);
                } else if (Long.TYPE == type) {
                    field.setLong(target, (Long)value);
                } else if (Float.TYPE == type) {
                    field.setFloat(target, ((Float)value).floatValue());
                } else if (Double.TYPE == type) {
                    field.setDouble(target, (Double)value);
                }
            } else {
                field.set(target, value);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ReflectionException(ex);
        }
    }

    private static <T> void makeAccessible(AccessibleObject accessibleObject) {
        if (!accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
    }

    public static class ReflectionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ReflectionException() {
        }

        public ReflectionException(String message, Throwable cause) {
            super(message, cause);
        }

        public ReflectionException(String message) {
            super(message);
        }

        public ReflectionException(Throwable cause) {
            super(cause);
        }
    }
}

