/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.editor.ogn.content;

import fr.cnav.saturne.DataType;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.Value;
import fr.cnav.saturne.editor.MessageTreeObject;
import fr.cnav.saturne.editor.ogn.content.AbstractContentHelper;
import fr.cnav.saturne.editor.ogn.content.ContentTypeFactory;
import fr.cnav.saturne.provider.SaturneItemProviderAdapterFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;

public class ContentHelperValue
extends AbstractContentHelper<Value> {
    private ContentTypeFactory contentTypeFactory;

    public ContentHelperValue(Map<EObject, Adapter> adapteursMap, SaturneItemProviderAdapterFactory saturneFactory, ContentTypeFactory contentTypeFactory) {
        super(adapteursMap, saturneFactory);
        this.contentTypeFactory = contentTypeFactory;
    }

    @Override
    public List<Object> getChildrenElt(Value inputElt, MessageTreeObject currentMessageTreeObject, boolean registerAdapter) {
        return this.contentTypeFactory.getEObjectHelper().getChildrenElt((EObject)inputElt, currentMessageTreeObject, registerAdapter);
    }

    @Override
    public MessageTreeObject getParent(Value value, MessageTreeObject currentMessageTreeObject) {
        MessageTreeObject returnMsg = null;
        EObject parent = value.eContainer();
        Declaration declaration = currentMessageTreeObject.getDeclaration();
        if (parent != null && parent instanceof DataType) {
            returnMsg = new MessageTreeObject(parent, declaration, this.contentTypeFactory.getDataTypeHelper().getFirstFieldWithDT((DataType)parent));
        }
        return returnMsg;
    }

    @Override
    public List<MessageTreeObject> getObjectsToRefresh(Value value, Notification notification) {
        ArrayList<MessageTreeObject> resultList = new ArrayList<MessageTreeObject>();
        EObject eContent = value.eContainer();
        if (eContent instanceof DataType) {
            DataType dataType = (DataType)eContent;
            List<Field> fields = this.contentTypeFactory.getDataTypeHelper().getFieldListWithDT(dataType);
            if (fields != null) {
                for (Field field : fields) {
                    resultList.addAll(this.getFieldListShownWithDT(value, dataType, field));
                }
            }
        }
        return resultList;
    }

    private List<MessageTreeObject> getFieldListShownWithDT(Value value, DataType dataType, Field field) {
        ArrayList<MessageTreeObject> result = new ArrayList<MessageTreeObject>();
        Standard standard = this.getStandard((EObject)value);
        if (this.getParentDeclarationBlock((EObject)field) == null) {
            MessageTreeObject messageTreeObjectValue = new MessageTreeObject(value, null, dataType);
            messageTreeObjectValue.setParentMessageTreeObject(new MessageTreeObject(field, null, field.eContainer()));
            result.add(messageTreeObjectValue);
        } else {
            for (Declaration declaration : standard.getDeclarations()) {
                if (!this.isDisplayed((EObject)value, declaration)) continue;
                MessageTreeObject messageTreeObjectValue = new MessageTreeObject(value, declaration, dataType);
                MessageTreeObject messageTreeObjectDataType = new MessageTreeObject(dataType, declaration, field);
                messageTreeObjectValue.setParentMessageTreeObject(messageTreeObjectDataType);
                result.add(messageTreeObjectValue);
            }
        }
        return result;
    }

    @Override
    public MessageTreeObject getObjectToSelect(Value value) {
        MessageTreeObject result = null;
        EObject eContainer = value.eContainer();
        if (eContainer != null && eContainer instanceof DataType) {
            DataType dataType = (DataType)eContainer;
            List<Field> fieldsListWithDT = this.contentTypeFactory.getDataTypeHelper().getFieldListWithDT(dataType);
            if (fieldsListWithDT != null) {
                for (Field field : fieldsListWithDT) {
                    Optional<MessageTreeObject> optionalMsgTO = this.getFirstShownValue(value, dataType, field);
                    if (!optionalMsgTO.isPresent()) continue;
                    result = optionalMsgTO.get();
                    break;
                }
            }
        }
        return result;
    }

    private Optional<MessageTreeObject> getFirstShownValue(Value value, DataType dataType, Field field) {
        Optional<MessageTreeObject> result = Optional.empty();
        Standard standard = this.getStandard((EObject)value);
        if (this.getParentDeclarationBlock((EObject)field) == null) {
            MessageTreeObject messageTreeObject = new MessageTreeObject(value, null, dataType);
            result = Optional.of(messageTreeObject);
        } else {
            for (Declaration declaration : standard.getDeclarations()) {
                if (!this.isDisplayed((EObject)value, declaration)) continue;
                MessageTreeObject messageTreeObject = new MessageTreeObject(value, declaration, dataType);
                result = Optional.of(messageTreeObject);
                break;
            }
        }
        return result;
    }
}

