/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.editor.ogn.content;

import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.DeclarationBlock;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.FieldRefinement;
import fr.cnav.saturne.GenericRule;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.UsageType;
import fr.cnav.saturne.editor.MessageTreeObject;
import fr.cnav.saturne.editor.ogn.content.AbstractContentHelper;
import fr.cnav.saturne.editor.ogn.content.ContentHelperEObject;
import fr.cnav.saturne.editor.ogn.content.ContentHelperField;
import fr.cnav.saturne.editor.ogn.content.IContentHelper;
import fr.cnav.saturne.provider.SaturneItemProviderAdapterFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ContentHelperGenericRule
extends AbstractContentHelper<GenericRule> {
    private IContentHelper<EObject> contentHelperEObject;
    private IContentHelper<Field> contentHelperField;

    public ContentHelperGenericRule(Map<EObject, Adapter> adapteursMap, SaturneItemProviderAdapterFactory saturneFactory) {
        super(adapteursMap, saturneFactory);
        this.contentHelperEObject = new ContentHelperEObject(adapteursMap, saturneFactory);
        this.contentHelperField = new ContentHelperField(adapteursMap, saturneFactory);
    }

    @Override
    public List<Object> getChildrenElt(GenericRule inputElt, MessageTreeObject currentMessageTreeObject, boolean registerAdapter) {
        return this.contentHelperEObject.getChildrenElt((EObject)inputElt, currentMessageTreeObject, registerAdapter);
    }

    @Override
    public MessageTreeObject getParent(GenericRule rule, MessageTreeObject currentMessageTreeObject) {
        MessageTreeObject returnMsg = null;
        Field parent = rule.getSubject();
        Declaration declaration = currentMessageTreeObject.getDeclaration();
        if (parent != null) {
            returnMsg = new MessageTreeObject(parent, declaration, parent.eContainer());
        }
        return returnMsg;
    }

    @Override
    public List<MessageTreeObject> getObjectsToRefresh(GenericRule rule, Notification notification) {
        ArrayList<MessageTreeObject> resultList = new ArrayList<MessageTreeObject>();
        EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
        if (4 == feature.getFeatureID() || 8 == feature.getFeatureID() || 6 == feature.getFeatureID()) {
            ArrayList<Field> fields = new ArrayList<Field>();
            if (notification.getOldValue() instanceof Field) {
                fields.add((Field)notification.getOldValue());
            }
            if (notification.getNewValue() instanceof Field) {
                fields.add((Field)notification.getNewValue());
            }
            for (Field field : fields) {
                resultList.addAll(this.contentHelperField.getObjectsToRefresh(field, notification));
            }
            Field parent = rule.getSubject();
            DeclarationBlock declarationBlockContainer = this.getParentDeclarationBlock((EObject)parent);
            if (declarationBlockContainer != null) {
                Standard standard = this.getStandard((EObject)rule);
                for (Declaration declaration : standard.getDeclarations()) {
                    resultList.add(new MessageTreeObject(rule, declaration, parent));
                }
            } else {
                resultList.add(new MessageTreeObject(rule, null, parent));
            }
        }
        return resultList;
    }

    @Override
    public MessageTreeObject getObjectToSelect(GenericRule rule) {
        MessageTreeObject result = null;
        Field field = rule.getSubject();
        Standard std = this.getStandard((EObject)field);
        if (std != null) {
            if (this.getParentDeclarationBlock((EObject)field) != null) {
                for (Declaration decl : std.getDeclarations()) {
                    boolean fieldDisplayed = this.isDisplayed((EObject)field, decl);
                    FieldRefinement refinement = (FieldRefinement)decl.getFieldRefinements().get(field);
                    if (fieldDisplayed && refinement == null && !UsageType.FORBIDDEN.equals((Object)field.getUsage())) {
                        result = new MessageTreeObject(rule, decl, field);
                    } else {
                        if (!fieldDisplayed || UsageType.FORBIDDEN.equals((Object)refinement.getUsage())) continue;
                        result = new MessageTreeObject(rule, decl, field);
                    }
                    break;
                }
            } else {
                result = new MessageTreeObject(rule, null, field);
            }
        }
        return result;
    }
}

