/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.editor.ogn.content;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.DeclarationBlock;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.editor.MessageTreeObject;
import fr.cnav.saturne.editor.ogn.content.AbstractContentHelper;
import fr.cnav.saturne.editor.ogn.content.ContentTypeFactory;
import fr.cnav.saturne.provider.SaturneItemProviderAdapterFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ContentHelperDeclarationBlock
extends AbstractContentHelper<DeclarationBlock> {
    private ContentTypeFactory contentTypeFactory;

    public ContentHelperDeclarationBlock(Map<EObject, Adapter> adapteursMap, SaturneItemProviderAdapterFactory saturneFactory, ContentTypeFactory contentTypeFactory) {
        super(adapteursMap, saturneFactory);
        this.contentTypeFactory = contentTypeFactory;
    }

    @Override
    public List<Object> getChildrenElt(DeclarationBlock declarationBlock, MessageTreeObject currentMessageTreeObject, boolean registerAdapter) {
        ArrayList<Object> result = new ArrayList<Object>();
        EList fields = declarationBlock.getChildrenFields();
        EList blocks = declarationBlock.getChildrenBlocks();
        Declaration declaration = currentMessageTreeObject.getDeclaration();
        if (declaration != null) {
            result.add(new MessageTreeObject(declaration, declaration, declarationBlock));
        }
        for (Field field : fields) {
            result.add(new MessageTreeObject(field, declaration, declarationBlock));
        }
        for (Block block : blocks) {
            result.add(new MessageTreeObject(block, declaration, declarationBlock));
        }
        for (Object e : result) {
            if (!(e instanceof MessageTreeObject) || !(((MessageTreeObject)e).getElement() instanceof EObject)) continue;
            this.registerAdapter((EObject)((MessageTreeObject)e).getElement(), registerAdapter);
        }
        return result;
    }

    @Override
    public MessageTreeObject getParent(DeclarationBlock declarationBlock, MessageTreeObject currentMessageTreeObject) {
        return this.contentTypeFactory.getBlockHelper().getParent((Block)declarationBlock, currentMessageTreeObject);
    }

    @Override
    public List<MessageTreeObject> getObjectsToRefresh(DeclarationBlock declarationBlock, Notification notification) {
        ArrayList<MessageTreeObject> resultList = new ArrayList<MessageTreeObject>();
        Standard std = this.getStandard((EObject)declarationBlock);
        EList declarations = null;
        if (std != null) {
            declarations = std.getDeclarations();
        }
        if (declarations != null) {
            for (Declaration decl : declarations) {
                resultList.add(new MessageTreeObject(declarationBlock, decl, declarationBlock.eContainer()));
            }
        }
        return resultList;
    }

    @Override
    public MessageTreeObject getObjectToSelect(DeclarationBlock declarationBlock) {
        MessageTreeObject result = null;
        Standard std = this.getStandard((EObject)declarationBlock);
        if (std != null && !std.getDeclarations().isEmpty()) {
            result = new MessageTreeObject(declarationBlock, (Declaration)std.getDeclarations().get(0), declarationBlock.eContainer());
        }
        return result;
    }
}

