/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.editor.autoctrl;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.BlockRefinement;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.DeclarationBlock;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.FieldRefinement;
import fr.cnav.saturne.GenericRule;
import fr.cnav.saturne.HeaderBlock;
import fr.cnav.saturne.Message;
import fr.cnav.saturne.MessageElement;
import fr.cnav.saturne.RuleSet;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.UsageType;
import fr.cnav.saturne.editor.MessageTreeObject;
import fr.cnav.saturne.provider.SaturneItemProviderAdapterFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class MessageTreeContentProvider
extends AdapterFactoryContentProvider {
    private SaturneItemProviderAdapterFactory saturneFactory;

    public MessageTreeContentProvider(AdapterFactory adapterFactory, SaturneItemProviderAdapterFactory theSaturneFactory) {
        super(adapterFactory);
        this.saturneFactory = theSaturneFactory;
    }

    public void dispose() {
        super.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Object msgElement;
        super.inputChanged(viewer, oldInput, newInput);
        if (newInput instanceof MessageTreeObject && (msgElement = ((MessageTreeObject)newInput).getElement()) instanceof Standard) {
            Standard standard = (Standard)msgElement;
            Adapter newAdapter = this.saturneFactory.createAdapter((Notifier)standard);
            standard.eAdapters().add((Object)newAdapter);
            RuleSet ruleSet = standard.getRules();
            if (ruleSet != null) {
                ruleSet.eAdapters().add((Object)this.saturneFactory.createAdapter((Notifier)ruleSet));
            }
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        List<Object> result = null;
        if (parentElement instanceof MessageTreeObject) {
            Block parentBlock;
            HeaderBlock headerBlock;
            Object msgElement = ((MessageTreeObject)parentElement).getElement();
            Declaration decl = ((MessageTreeObject)parentElement).getDeclaration();
            if (msgElement instanceof Standard) {
                Standard standard = (Standard)msgElement;
                msgElement = standard.getMessage();
            }
            if (msgElement instanceof Message) {
                headerBlock = ((Message)msgElement).getHeaderBlock();
                Block footerBlock = ((Message)msgElement).getFooterBlock();
                result = new ArrayList(2);
                result.add(new MessageTreeObject(headerBlock));
                result.add(new MessageTreeObject(footerBlock));
            } else if (msgElement instanceof HeaderBlock) {
                headerBlock = (HeaderBlock)msgElement;
                EList fields = headerBlock.getChildrenFields();
                EList blocks = headerBlock.getChildrenBlocks();
                Standard standard = (Standard)headerBlock.eContainer().eContainer();
                EList declarations = standard.getDeclarations();
                result = this.getChildrenOfBlock((EList<Field>)fields, (EList<Block>)blocks, null);
                DeclarationBlock declarationBlock = headerBlock.getDeclarationBlock();
                int i = 0;
                while (i < declarations.size()) {
                    decl = (Declaration)declarations.get(i);
                    result.add(new MessageTreeObject(declarationBlock, decl));
                    ++i;
                }
            } else if (msgElement instanceof Block) {
                parentBlock = (Block)msgElement;
                EList fields = parentBlock.getChildrenFields();
                EList blocks = parentBlock.getChildrenBlocks();
                result = this.getChildrenOfBlock((EList<Field>)fields, (EList<Block>)blocks, decl);
            } else if (msgElement instanceof BlockRefinement) {
                parentBlock = ((BlockRefinement)msgElement).getBlock();
                EList fields = parentBlock.getChildrenFields();
                EList blocks = parentBlock.getChildrenBlocks();
                result = this.getChildrenOfBlock((EList<Field>)fields, (EList<Block>)blocks, decl);
            } else {
                result = msgElement instanceof Field ? this.getChildrenOfField((Field)msgElement, decl) : (msgElement instanceof FieldRefinement ? this.getChildrenOfField(((FieldRefinement)msgElement).getField(), decl) : new ArrayList(0));
            }
        } else {
            result = new ArrayList<MessageTreeObject>(0);
        }
        return result.toArray();
    }

    private List<Object> getChildrenOfField(Field field, Declaration decl) {
        EList rules = field.getRules();
        ArrayList<Object> result = new ArrayList<Object>(rules.size());
        for (GenericRule genericRule : rules) {
            result.add(new MessageTreeObject(genericRule, decl, field));
        }
        return result;
    }

    private List<Object> getChildrenOfBlock(EList<Field> fieldsBlock, EList<Block> childrenBlocks, Declaration decl) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < fieldsBlock.size()) {
            Field field = (Field)fieldsBlock.get(i);
            if (decl == null) {
                result.add(new MessageTreeObject(field, null));
            } else {
                FieldRefinement fieldRefinement = (FieldRefinement)decl.getFieldRefinements().get(field);
                if (fieldRefinement != null) {
                    result.add(new MessageTreeObject(fieldRefinement, decl));
                } else {
                    result.add(new MessageTreeObject(field, decl));
                }
            }
            ++i;
        }
        i = 0;
        while (i < childrenBlocks.size()) {
            Block block = (Block)childrenBlocks.get(i);
            if (!(block instanceof DeclarationBlock) && decl == null) {
                result.add(new MessageTreeObject(block, null));
            } else if (!(block instanceof DeclarationBlock)) {
                BlockRefinement blockRefinement = (BlockRefinement)decl.getBlockRefinements().get(block);
                if (blockRefinement == null) {
                    result.add(new MessageTreeObject(block, decl));
                } else {
                    result.add(new MessageTreeObject(blockRefinement, decl));
                }
            }
            ++i;
        }
        return result;
    }

    public Object getParent(Object element) {
        if (element instanceof MessageTreeObject) {
            Declaration declaration;
            MessageTreeObject messageTreeObject = (MessageTreeObject)element;
            EObject msgElement = (EObject)messageTreeObject.getElement();
            EObject parent = null;
            if (msgElement instanceof FieldRefinement) {
                FieldRefinement fieldRefinement = (FieldRefinement)msgElement;
                parent = fieldRefinement.getField().eContainer();
            } else if (msgElement instanceof BlockRefinement) {
                BlockRefinement blockRefinement = (BlockRefinement)msgElement;
                parent = blockRefinement.getBlock().eContainer();
            } else if (msgElement instanceof GenericRule) {
                GenericRule rule = (GenericRule)msgElement;
                parent = rule.getSubject();
            } else {
                parent = msgElement.eContainer();
            }
            Declaration declaration2 = declaration = !(parent instanceof HeaderBlock) ? messageTreeObject.getDeclaration() : null;
            if (parent != null) {
                return new MessageTreeObject(parent, declaration);
            }
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        boolean result = false;
        if (element instanceof MessageTreeObject) {
            EObject msgElement = (EObject)((MessageTreeObject)element).getElement();
            Declaration declaration = ((MessageTreeObject)element).getDeclaration();
            if (msgElement instanceof Block && !UsageType.FORBIDDEN.equals((Object)((Block)msgElement).getUsage()) && ((Block)msgElement).getUpperBound() != 0) {
                Block bloc = (Block)msgElement;
                int childrenSize = bloc.getChildrenFields().size() + bloc.getChildrenBlocks().size();
                if (childrenSize > 0) {
                    result = true;
                }
            } else if (this.isBlockRefinementNotForbidden(msgElement, declaration)) {
                Block bloc = ((BlockRefinement)msgElement).getBlock();
                int childrenSize = bloc.getChildrenFields().size() + bloc.getChildrenBlocks().size();
                if (childrenSize > 0) {
                    result = true;
                }
            } else if (this.isFieldNotForbidden(msgElement)) {
                result = ((Field)msgElement).getRules().size() > 0;
            } else if (this.isFieldRefinementNotForbidden(msgElement, declaration)) {
                result = ((FieldRefinement)msgElement).getField().getRules().size() > 0;
            }
        }
        return result;
    }

    private boolean isFieldNotForbidden(EObject msgElement) {
        return msgElement instanceof Field && !UsageType.FORBIDDEN.equals((Object)((Field)msgElement).getUsage());
    }

    private boolean isFieldRefinementNotForbidden(EObject msgElement, Declaration declaration) {
        return msgElement instanceof FieldRefinement && !UsageType.FORBIDDEN.equals((Object)declaration.getUsage((MessageElement)((FieldRefinement)msgElement).getField()));
    }

    private boolean isBlockRefinementNotForbidden(EObject msgElement, Declaration declaration) {
        return msgElement instanceof BlockRefinement && !UsageType.FORBIDDEN.equals((Object)declaration.getUsage((MessageElement)((BlockRefinement)msgElement).getBlock())) && declaration.getBlockUpperBound(((BlockRefinement)msgElement).getBlock()) != 0;
    }
}

