/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.models;

import fr.cnav.autocontrole.models.MessageFile;
import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.report.model.Context;
import fr.cnav.saturne.validator.report.IReportLogger;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class ReportProvider {
    private final IReportLogger reportResult;
    private final int declarationNbr;
    private int declarationOKNbr;
    private int declarationKONbr;
    private int anomalieNbr;
    private int anomalieBloquanteNbr;
    private int avertissementNbr;
    private BigInteger individualNbr;
    private final Set<Context> visitedContext;

    public ReportProvider(IReportLogger reportResult) {
        this.reportResult = reportResult;
        this.declarationNbr = reportResult.getReport().getRootContext().getContextChildren().size();
        this.visitedContext = new HashSet<Context>();
        this.calculateVisitedContext(reportResult.getReport().getRootContext());
        this.computeAllNbr();
    }

    private void calculateVisitedContext(Context rootContext) {
        List declarationContexts;
        Integer tooManyAnomalyLineNumber = this.getTooManyAnomalyLineNumber(rootContext);
        if (tooManyAnomalyLineNumber != null && (declarationContexts = rootContext.getContextChildren()).size() >= 1) {
            ListIterator declarationContextsIterator = declarationContexts.listIterator(declarationContexts.size());
            boolean allFilled = false;
            while (declarationContextsIterator.hasPrevious() && !allFilled) {
                Context context = (Context)declarationContextsIterator.previous();
                if (tooManyAnomalyLineNumber < context.getStartLine()) {
                    this.visitedContext.add(context);
                    continue;
                }
                allFilled = true;
            }
        }
    }

    private int getTooManyAnomalyLineNumber(Context rootContext) {
        Anomaly anomaly;
        int result = 0;
        int anomaliesSize = rootContext.getAnomalies().size();
        if (anomaliesSize > 0 && "99".equals((anomaly = (Anomaly)rootContext.getAnomalies().get(anomaliesSize - 1)).getCode())) {
            result = ((Anomaly)rootContext.getAnomalies().get(rootContext.getAnomalies().size() - 1)).getNumber();
        }
        return result;
    }

    private void computeAllNbr() {
        this.declarationOKNbr = 0;
        this.declarationKONbr = 0;
        this.anomalieNbr = 0;
        this.anomalieBloquanteNbr = 0;
        this.avertissementNbr = 0;
        this.individualNbr = new BigInteger("0");
        if (this.reportResult.getReport().getRootContext() != null && this.reportResult.getReport().getRootContext().getAnomalies() != null) {
            this.anomalieNbr = this.reportResult.getAnomaliesNumber();
        }
        this.individualNbr = BigInteger.valueOf(MessageFile.getInstance().getIndividualNumber());
        if (this.reportResult.getReport().getRootContext() != null && this.reportResult.getReport().getRootContext().getContextChildren() != null) {
            for (Context report : this.reportResult.getReport().getRootContext().getContextChildren()) {
                if (!report.hasBeenDirectlyValidated()) continue;
                if (report.isValid()) {
                    if (!this.visitedContext.contains(report)) continue;
                    ++this.declarationOKNbr;
                    continue;
                }
                ++this.declarationKONbr;
            }
        }
        if (this.reportResult.getReport().getRootContext() != null) {
            this.anomalieBloquanteNbr = this.getBlockingAnoNbr(this.reportResult.getReport().getRootContext());
        }
        this.avertissementNbr = this.anomalieNbr - this.anomalieBloquanteNbr;
    }

    private int getBlockingAnoNbr(Context curContext) {
        int anoBlocingNbr = 0;
        for (Anomaly anomaly : curContext.getAnomalies()) {
            if (!anomaly.isBlocking()) continue;
            anoBlocingNbr += anomaly.getNumber();
        }
        for (Context context : curContext.getContextChildren()) {
            anoBlocingNbr += this.getBlockingAnoNbr(context);
        }
        return anoBlocingNbr;
    }

    public BigInteger getSalarieNbr() {
        return this.individualNbr;
    }

    public int getDeclarationNbr() {
        return this.declarationNbr;
    }

    public int getDeclarationOKNbr() {
        return this.declarationOKNbr;
    }

    public int getDeclarationKONbr() {
        return this.declarationKONbr;
    }

    public int getAnolamieNbr() {
        return this.anomalieNbr;
    }

    public int getAnomalieBloquanteNbr() {
        return this.anomalieBloquanteNbr;
    }

    public int getAvertissementNbr() {
        return this.avertissementNbr;
    }

    public String getDeclarationNbrAsString() {
        return Integer.toString(this.declarationNbr);
    }

    public String getDeclarationOKNbrAsString() {
        return Integer.toString(this.declarationOKNbr);
    }

    public String getDeclarationKONbrAsString() {
        return Integer.toString(this.declarationKONbr);
    }

    public String getAnolamieNbrAsString() {
        return Integer.toString(this.anomalieNbr);
    }

    public String getAnolamieBloquanteNbrAsString() {
        return Integer.toString(this.anomalieBloquanteNbr);
    }

    public String getAvertissementNbrAsString() {
        return Integer.toString(this.avertissementNbr);
    }

    public String getSalarieNbrAsString() {
        return this.individualNbr.toString();
    }
}

