/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.syntax;

import fr.cnav.saturne.NatureType;
import fr.cnav.saturne.api.model.access.CSVDataSourceDescription;
import fr.cnav.saturne.api.model.access.CSVExternalDataTableDescription;
import fr.cnav.saturne.api.model.access.DataSourceDescription;
import fr.cnav.saturne.api.model.access.DataTypeDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.ExternalDataTableDescription;
import fr.cnav.saturne.api.model.access.ExternalDataTypeDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.utils.DataTypeUtil;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.engine.IRule;
import fr.cnav.saturne.validator.engine.IRuleResult;
import fr.cnav.saturne.validator.engine.RuleFailure;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.syntax.AbstractFieldSyntaxControl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CRESyntaxControl
extends AbstractFieldSyntaxControl {
    private final List<ExternalDataTableDescription> activeDataTables;
    private final String fullQualifiedId;
    private final StandardAccessor modelAccessor;

    public CRESyntaxControl(int id, String code, FieldDescription target, ControlMessages controlMessage, DeclarationDescription declaration, StandardAccessor modelAccessor) {
        super(id, code, target, controlMessage, declaration);
        DataTypeDescription dataType = target.getDataType();
        List dataTableList = null;
        if (dataType instanceof ExternalDataTypeDescription) {
            dataTableList = ((ExternalDataTypeDescription)dataType).getExternalDataTables();
        }
        if (!dataType.getNature().equals((Object)NatureType.EXTERNAL_REFERENTIAL)) {
            throw new IllegalArgumentException("Une r\u00e8gle CRE ne peut \u00eatre d\u00e9clench\u00e9e sur une rubrique dont la nature n'est pas externalDataType.");
        }
        this.fullQualifiedId = target.getFullQualifiedId();
        this.activeDataTables = dataTableList;
        this.modelAccessor = modelAccessor;
    }

    @Override
    public List<FieldDescription> getUsedData() {
        if (this.getTarget() instanceof FieldDescription) {
            return Stream.of((FieldDescription)this.getTarget()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        return new ArrayList<FieldDescription>();
    }

    private boolean valueInExternalDataTables(String value, DataTypeDescription dataType) {
        int size = this.activeDataTables.size();
        int i = 0;
        while (i < size) {
            ExternalDataTableDescription externalDataTable = this.activeDataTables.get(i);
            if (externalDataTable instanceof CSVExternalDataTableDescription) {
                CSVExternalDataTableDescription csvExternalDataTable = (CSVExternalDataTableDescription)externalDataTable;
                DataSourceDescription dataSource = externalDataTable.getDataSource();
                if (dataSource instanceof CSVDataSourceDescription) {
                    String referentialName = ((CSVDataSourceDescription)dataSource).getFilename();
                    String columnId = csvExternalDataTable.getColumnId();
                    if (columnId == null) {
                        columnId = ((CSVDataSourceDescription)dataSource).getColumnId();
                    }
                    Set referential = this.modelAccessor.getReferential(referentialName, columnId);
                    DataTypeUtil dataTypeUtil = new DataTypeUtil();
                    if (referential != null && referential.contains(value) && !dataTypeUtil.isFilteredValue(value, dataType)) {
                        return true;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    @Override
    public IRuleResult run(IMessageField<?> subject) {
        IRuleResult result;
        String value = subject.getValueAsString();
        if (value == null || "".equals(value)) {
            return IRule.SUCCESS;
        }
        boolean isOneOfExternalReferantialValues = this.valueInExternalDataTables(value, subject.getStandardFieldDescription().getDataType());
        if (!isOneOfExternalReferantialValues && this.activeDataTables.size() > 0) {
            String message = this.controlMessage.getMessage("syntactic.messages.CRE", new Object[]{this.fullQualifiedId});
            result = new RuleFailure(this, subject, subject.getParent(), message);
        } else {
            result = IRule.SUCCESS;
        }
        return result;
    }
}

