/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.functions;

import fr.cnav.saturne.options.Key;
import fr.cnav.saturne.options.OptionMap;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.api.AbstractKBDescriptor;
import fr.cnav.saturne.validator.engine.ValidatorWithCleaner;
import fr.cnav.saturne.validator.functions.AbstractValidationFunctions;
import fr.cnav.saturne.validator.functions.ValidationFunctionException;
import fr.cnav.saturne.validator.impl.FormatType;
import fr.cnav.saturne.validator.message.MessageProvider;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.TooManyAnomaliesException;
import fr.cnav.saturne.validator.service.IValidationListener;
import fr.cnav.saturne.validator.service.ValidationEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationFunctions
extends AbstractValidationFunctions {
    private Optional<IValidationListener> listener = Optional.empty();
    private FormatType messageFormat;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ValidationFunctions(ControlMessages controlMessages, OptionMap optionsMap, AbstractKBDescriptor kbDescriptor) throws ValidationFunctionException {
        super(controlMessages, optionsMap, kbDescriptor);
        this.messageFormat = (FormatType)((Object)this.getKbDescriptor().getOptions().getOption(new Key("fr.cnav.saturne.validator.inputFormatValidation")));
        if (this.messageFormat == null) {
            this.messageFormat = FormatType.TXT;
        } else if (FormatType.TXTNP.equals((Object)this.messageFormat) || FormatType.CSVNP.equals((Object)this.messageFormat) || FormatType.XMLNP.equals((Object)this.messageFormat)) {
            Key xmlNoPrefixKey = new Key("fr.cnav.saturne.validator.xmlWithNoPrefix");
            optionsMap.setOption(xmlNoPrefixKey, (Object)true);
        } else if (FormatType.PFX.equals((Object)this.messageFormat)) {
            Key modelConfPath = new Key("fr.cnav.saturne.validator.positional.modelConfPfx");
            optionsMap.setOption(modelConfPath, (Object)((String)this.getKbDescriptor().getOptions().getOption(modelConfPath)));
            Key idExtractor = new Key("fr.cnav.saturne.validator.positional.idExtractor");
            optionsMap.setOption(idExtractor, (Object)((Class)this.getKbDescriptor().getOptions().getOption(idExtractor)));
        }
    }

    public void validateFromText(File textFileInput, File xmlFileoutput, IReportLogger reportLogger) throws ValidationFunctionException, TooManyAnomaliesException {
        this.rootMessageBlock = null;
        this.logger.info("[Saturne] Start of the syntactic and semantic validation");
        if (textFileInput == null) {
            throw new IllegalArgumentException("The parameter inputFile of the conversion method is null, does not exist or is not a file");
        }
        if (xmlFileoutput == null) {
            throw new IllegalArgumentException("The parameter outputFile of the conversion method is null, does not exist or is not a file");
        }
        FileInputStream textInputStream = null;
        FileOutputStream xmlOutputStream = null;
        FileInputStream xmlInputStream = null;
        try {
            try {
                try {
                    textInputStream = new FileInputStream(textFileInput);
                    xmlOutputStream = new FileOutputStream(xmlFileoutput);
                    this.notify(ValidationEvent.VALIDATION_START, reportLogger);
                    if (this.stopOnSyntacticError.booleanValue()) {
                        this.notify(ValidationEvent.CONVERSION_START, reportLogger);
                        this.convertAndSerializeToXml(textInputStream, xmlOutputStream, reportLogger, "utf-8", this.messageFormat);
                        this.notify(ValidationEvent.CONVERSION_END, reportLogger);
                        textInputStream.close();
                        xmlOutputStream.close();
                        int nbConversionAno = reportLogger.getAnomaliesNumber();
                        if (!this.stopOnConversionError.booleanValue() || nbConversionAno == 0) {
                            xmlInputStream = new FileInputStream(xmlFileoutput);
                            this.logger.info("[Saturne] Start of the syntactic validation");
                            this.notify(ValidationEvent.SYNTAX_VALIDATION_START, reportLogger);
                            this.validateOnePassFromXml(xmlInputStream, reportLogger, true, false);
                            this.notify(ValidationEvent.SYNTAX_VALIDATION_END, reportLogger);
                            this.logger.info("[Saturne] End of the syntactic validation");
                            xmlInputStream.close();
                            int nbSyntacticAno = reportLogger.getAnomaliesNumber() - nbConversionAno;
                            if (nbSyntacticAno == 0) {
                                xmlInputStream = new FileInputStream(xmlFileoutput);
                                this.logger.info("[Saturne] Start of the semantic validation");
                                this.notify(ValidationEvent.SEMANTIC_VALIDATION_START, reportLogger);
                                this.validateOnePassFromXml(xmlInputStream, reportLogger, false, true);
                                this.notify(ValidationEvent.SEMANTIC_VALIDATION_END, reportLogger);
                                this.logger.info("[Saturne] End of the semantic validation");
                                xmlInputStream.close();
                            }
                        }
                    } else if (FormatType.XML.equals((Object)this.messageFormat) || FormatType.XMLNP.equals((Object)this.messageFormat)) {
                        IOUtils.copyLarge((InputStream)textInputStream, (OutputStream)xmlOutputStream);
                        textInputStream.close();
                        textInputStream = new FileInputStream(textFileInput);
                        this.validateOnePassFromXml(textInputStream, reportLogger, true, true);
                    } else if (this.stopOnConversionError.booleanValue()) {
                        this.notify(ValidationEvent.CONVERSION_START, reportLogger);
                        this.convertAndSerializeToXml(textInputStream, xmlOutputStream, reportLogger, "UTF-8", this.messageFormat);
                        this.notify(ValidationEvent.CONVERSION_END, reportLogger);
                        textInputStream.close();
                        xmlOutputStream.close();
                        if (reportLogger.getAnomaliesNumber() == 0) {
                            xmlInputStream = new FileInputStream(xmlFileoutput);
                            this.validateOnePassFromXml(xmlInputStream, reportLogger, true, true);
                        }
                    } else {
                        this.validateOnePassFromText(textInputStream, xmlOutputStream, reportLogger, true, true, this.messageFormat);
                    }
                }
                finally {
                    if (textInputStream != null) {
                        textInputStream.close();
                    }
                    if (xmlOutputStream != null) {
                        xmlOutputStream.close();
                    }
                    if (xmlInputStream != null) {
                        xmlInputStream.close();
                    }
                }
            }
            catch (IOException e) {
                this.logger.error("[Saturne] The input or output file can't be read", (Throwable)e);
                throw new ValidationFunctionException(e);
            }
            catch (TooManyAnomaliesException e) {
                this.notify(ValidationEvent.VALIDATION_END, reportLogger);
                throw e;
            }
        }
        finally {
            if (xmlOutputStream != null) {
                try {
                    xmlOutputStream.close();
                }
                catch (IOException e) {
                    this.logger.error("[Saturne] The input or output file can't be read", (Throwable)e);
                    throw new ValidationFunctionException(e);
                }
            }
        }
        this.logger.info("[Saturne] End of the syntactic and semantic validation");
        this.notify(ValidationEvent.VALIDATION_END, reportLogger);
    }

    public void notify(ValidationEvent event, IReportLogger reportLogger) {
        if (this.listener.isPresent()) {
            this.listener.get().notify(String.valueOf(event.getMsg()) + " on " + reportLogger.getReport().getValidationId(), event, reportLogger);
        }
    }

    public void setListener(IValidationListener listener) {
        if (listener != null) {
            this.listener = Optional.of(listener);
        }
    }

    public void validate(IMessageBlock messageBlock, IReportLogger reportLogger) throws IOException, ValidationFunctionException, TooManyAnomaliesException {
        this.logger.info("[Saturne] Start of the syntactic validation");
        try {
            this.runValidation(messageBlock, reportLogger, true, true);
        }
        catch (TreeProcessingException e) {
            this.logger.error("[Saturne] The semantic has failed.", (Throwable)e);
            throw new ValidationFunctionException(e);
        }
        this.logger.info("[Saturne] End of the syntactic validation");
    }

    protected void runValidation(IMessageBlock messageBlock, IReportLogger reportLogger, boolean validateSemantic, boolean validateSyntactic) throws TooManyAnomaliesException, ValidationFunctionException, TreeProcessingException {
        if (messageBlock == null) {
            throw new IllegalArgumentException("The parameter messageBlock of the conversion method can't be null");
        }
        if (reportLogger == null) {
            throw new IllegalArgumentException("The parameter reportLogger of the conversion method can't be null");
        }
        if (this.standardFile != null) {
            throw new IllegalArgumentException("It is forbidden to validate a Standard loaded from the workspace");
        }
        MessageProvider messageProvider = new MessageProvider(this.getModelAccessor());
        ValidatorWithCleaner validatorWithCleaner = new ValidatorWithCleaner(this.getModelAccessor(), reportLogger, this.executorAndCleanerRunner, validateSyntactic, validateSemantic, this.unloadingAcitvated, this.getControlMessages());
        messageProvider.addConsumer(validatorWithCleaner);
        try {
            messageProvider.notifiesMessage(messageBlock);
        }
        catch (TreeProcessingException e) {
            if (e.getCause() instanceof TooManyAnomaliesException) {
                TooManyAnomaliesException t = (TooManyAnomaliesException)e.getCause();
                throw t;
            }
            throw e;
        }
    }

    public void validateSyntax(IMessageBlock messageBlock, IReportLogger reportLogger) throws IOException, ValidationFunctionException, TooManyAnomaliesException {
        this.logger.info("[Saturne] Start of the syntactic validation");
        try {
            this.runValidation(messageBlock, reportLogger, false, true);
        }
        catch (TreeProcessingException e) {
            this.logger.error("[Saturne] The semantic has failed.", (Throwable)e);
            throw new ValidationFunctionException(e);
        }
        this.logger.info("[Saturne] End of the syntactic validation");
    }

    public void validateSemantic(IMessageBlock messageBlock, IReportLogger reportLogger) throws IOException, ValidationFunctionException, TooManyAnomaliesException {
        this.logger.info("[Saturne] Start of the semantic validation");
        try {
            this.runValidation(messageBlock, reportLogger, true, false);
        }
        catch (TreeProcessingException e) {
            this.logger.error("[Saturne] The semantic has failed.", (Throwable)e);
            throw new ValidationFunctionException(e);
        }
        this.logger.info("[Saturne] End of the semantic validation");
    }
}

