/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.conversion.xml;

import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.MessageDescription;
import fr.cnav.saturne.api.model.access.StandardDescription;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.conversion.ConversionSerializationException;
import fr.cnav.saturne.validator.conversion.OriginalValueOptionValue;
import fr.cnav.saturne.validator.conversion.xml.XMLFormattingException;
import fr.cnav.saturne.validator.conversion.xml.XMLFormattingWriter;
import fr.cnav.saturne.validator.conversion.xml.XMLSerializer;
import fr.cnav.saturne.validator.conversion.xml.XMLUtil;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.message.api.IMessageFieldAlphanum;
import fr.cnav.saturne.validator.message.api.IMessageFieldDate;
import fr.cnav.saturne.validator.message.api.IMessageFieldNum;
import java.io.OutputStream;

public class XMLStreamSerializer
extends XMLSerializer {
    private boolean doSerializeChild;

    public XMLStreamSerializer(StandardDescription theStandard, OutputStream outputStream, String encoding, OriginalValueOptionValue emitOriginalValue, boolean emitOriginalLineNumber) throws ConversionSerializationException {
        this(theStandard, outputStream, encoding, emitOriginalValue, emitOriginalLineNumber, false);
    }

    public XMLStreamSerializer(StandardDescription theStandard, OutputStream outputStream, String encoding, OriginalValueOptionValue emitOriginalValue, boolean emitOriginalLineNumber, boolean xmlNoPrefix) throws ConversionSerializationException {
        super(theStandard, outputStream, encoding, emitOriginalValue, emitOriginalLineNumber, xmlNoPrefix);
    }

    public XMLStreamSerializer(StandardDescription theStandard, OriginalValueOptionValue emitOriginalValue, boolean emitOriginalLineNumber, XMLFormattingWriter parent) throws ConversionSerializationException {
        this(theStandard, emitOriginalValue, emitOriginalLineNumber, parent, false);
    }

    public XMLStreamSerializer(StandardDescription theStandard, OriginalValueOptionValue emitOriginalValue, boolean emitOriginalLineNumber, XMLFormattingWriter parent, boolean xmlNoPrefix) throws ConversionSerializationException {
        super(theStandard, emitOriginalValue, emitOriginalLineNumber, parent, xmlNoPrefix);
    }

    @Override
    public void startTree() throws TreeProcessingException {
        super.startTree();
    }

    @Override
    public void endTree() throws TreeProcessingException {
        super.endTree();
    }

    @Override
    public void enterBlock(IMessageBlock block) throws TreeProcessingException {
        String blocQualifiedId = block.getStandardBlockDescription().getFullQualifiedId();
        String blocXMLTag = XMLUtil.getTagNameFromQualifiedId(blocQualifiedId);
        String blocName = block.getStandardBlockDescription().getName();
        try {
            boolean bl = this.doSerializeChild = blocName != null;
            if (this.nameSpace == null) {
                this.writer.writeStartElement(blocXMLTag);
            } else {
                this.writer.writeStartElement(this.nameSpace, blocXMLTag);
            }
            if (block.getStandardBlockDescription() instanceof MessageDescription) {
                if (this.nameSpace != null) {
                    this.writer.writeNamespace(this.nameSpacePrefix, this.nameSpace);
                }
                this.writer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            }
        }
        catch (XMLFormattingException exception) {
            throw new TreeProcessingException("An exception has occured while appending the beginning of the " + block.getStandardBlockDescription().getFullQualifiedId() + " bloc writing: " + exception.getMessage(), exception);
        }
    }

    @Override
    public void exitBlock(IMessageBlock block) throws TreeProcessingException {
        super.exitBlock(block);
        this.doSerializeChild = false;
    }

    @Override
    public void signalAlphanumField(IMessageFieldAlphanum field) throws TreeProcessingException {
        this.writeField(field);
    }

    @Override
    public void signalNumericField(IMessageFieldNum field) throws TreeProcessingException {
        this.writeField(field);
    }

    @Override
    public void signalDateField(IMessageFieldDate field) throws TreeProcessingException {
        this.writeField(field);
    }

    @Override
    public void signalDeclaration(IMessageBlock block, DeclarationDescription declaration) throws TreeProcessingException {
        try {
            if (declaration != null) {
                if (this.nameSpacePrefix == null) {
                    this.writer.writeAttribute("xsi:type", declaration.getName().replaceAll(" ", "_"));
                } else {
                    this.writer.writeAttribute("xsi:type", String.valueOf(this.nameSpacePrefix) + ":" + declaration.getName().replaceAll(" ", "_"));
                }
            }
        }
        catch (XMLFormattingException exception) {
            throw new TreeProcessingException("An exception has occured while appending the beginning of the " + block.getStandardBlockDescription().getFullQualifiedId() + " bloc writing: " + exception.getMessage(), exception);
        }
    }

    private void writeField(IMessageField<?> field) throws TreeProcessingException {
        if (this.doSerializeChild) {
            try {
                String formatedValue;
                String fieldQualifiedId = field.getStandardFieldDescription().getFullQualifiedId();
                String fieldXMLTag = XMLUtil.getTagNameFromQualifiedId(fieldQualifiedId);
                String originalValue = field.getOriginalValueAsString();
                if (this.nameSpace == null) {
                    this.writer.writeStartElement(fieldXMLTag);
                } else {
                    this.writer.writeStartElement(this.nameSpace, fieldXMLTag);
                }
                if (this.doShowOriginalLineNumber) {
                    this.writer.writeAttribute("originLineNumber", field.getFieldLocalizer().getLocalization());
                }
                if ((formatedValue = this.getFormatedValue(field)) != null) {
                    this.writer.writeAttribute("originalValue", originalValue);
                    this.writer.writeCharacters(formatedValue);
                } else {
                    this.writer.writeCharacters(originalValue);
                }
                this.writer.writeEndElement(false, false);
            }
            catch (XMLFormattingException exception) {
                throw new TreeProcessingException("An exception has occured while the " + field.getStandardFieldDescription().getFullQualifiedId() + " field writing: " + exception.getMessage(), exception);
            }
        }
    }
}

