/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.conversion.json;

import com.google.gson.stream.JsonWriter;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.StandardDescription;
import fr.cnav.saturne.validator.ITreeAndDeclarationConsumer;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageFieldAlphanum;
import fr.cnav.saturne.validator.message.api.IMessageFieldDate;
import fr.cnav.saturne.validator.message.api.IMessageFieldNum;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;

public class JsonStreamSerializer
implements ITreeAndDeclarationConsumer {
    private static final String EXCEPTION_CONVERTED_FILE = "An exception has occured while appending the footer of the converted file: ";
    JsonWriter writer;

    public JsonStreamSerializer(StandardDescription theStandard, OutputStream outputStream, Charset charset) throws UnsupportedEncodingException {
        this.writer = new JsonWriter((Writer)new OutputStreamWriter(outputStream, charset));
        this.writer.setIndent("    ");
    }

    @Override
    public void startTree() throws TreeProcessingException {
        try {
            this.writer.beginObject();
        }
        catch (IOException e) {
            throw new TreeProcessingException("An exception has occured while writing the file: " + e.getMessage(), e);
        }
    }

    @Override
    public void endTree() throws TreeProcessingException {
        try {
            this.writer.endObject();
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            throw new TreeProcessingException(EXCEPTION_CONVERTED_FILE + e.getMessage(), e);
        }
    }

    @Override
    public void enterBlock(IMessageBlock block) throws TreeProcessingException {
        try {
            this.writer.name(block.getStandardBlockDescription().getFullQualifiedId());
            this.writer.beginObject();
        }
        catch (IOException e) {
            throw new TreeProcessingException(EXCEPTION_CONVERTED_FILE + e.getMessage(), e);
        }
    }

    @Override
    public void exitBlock(IMessageBlock block) throws TreeProcessingException {
        try {
            this.writer.endObject();
        }
        catch (IOException e) {
            throw new TreeProcessingException(EXCEPTION_CONVERTED_FILE + e.getMessage(), e);
        }
    }

    @Override
    public void signalAlphanumField(IMessageFieldAlphanum field) throws TreeProcessingException {
        try {
            this.writer.name(field.getStandardFieldDescription().getFullQualifiedId());
            this.writer.value((String)field.getValue());
        }
        catch (IOException e) {
            throw new TreeProcessingException(EXCEPTION_CONVERTED_FILE + e.getMessage(), e);
        }
    }

    @Override
    public void signalNumericField(IMessageFieldNum field) throws TreeProcessingException {
        try {
            this.writer.name(field.getStandardFieldDescription().getFullQualifiedId());
            this.writer.value((Number)field.getValue());
        }
        catch (IOException e) {
            throw new TreeProcessingException(EXCEPTION_CONVERTED_FILE + e.getMessage(), e);
        }
    }

    @Override
    public void signalDateField(IMessageFieldDate field) throws TreeProcessingException {
        try {
            this.writer.name(field.getStandardFieldDescription().getFullQualifiedId());
            this.writer.value(field.getOriginalValue());
        }
        catch (IOException e) {
            throw new TreeProcessingException(EXCEPTION_CONVERTED_FILE + e.getMessage(), e);
        }
    }

    @Override
    public void signalDeclaration(IMessageBlock block, DeclarationDescription declaration) throws TreeProcessingException {
    }
}

