/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrol.export;

import fr.cnav.autocontrole.exception.AutoCtrlException;
import fr.cnav.autocontrole.helpers.StandardHelper;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.IReportSerializer;
import fr.cnav.saturne.validator.report.SerializationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public final class ReportExporter {
    private static final int ONE_HUNDRED_AND_FORTY = 140;

    private ReportExporter() {
    }

    public static void exportWithSerializer(String exportFilePath, IProgressMonitor monitor, IReportSerializer serializer, IReportLogger logger) throws AutoCtrlException, FileNotFoundException, SerializationException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)140);
        FileOutputStream fileOutputStream = new FileOutputStream(exportFilePath);
        StandardAccessor modelAccessor = StandardHelper.getInstance().getNormDescriptor().getStandardAccessor();
        Standard standard = modelAccessor.getStandard();
        serializer.serialize((OutputStream)fileOutputStream, logger, standard.getNamespacePrefix(), standard.getNameSpace(), modelAccessor);
        progress.done();
    }

    public static void exportWithDefaultSerializer(File reportFile, String exportFilePath, IProgressMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)140);
        File fileDest = new File(exportFilePath);
        if (fileDest.exists()) {
            fileDest.delete();
        }
        fileDest.createNewFile();
        ReportExporter.copyFileUsingChannel(reportFile, fileDest);
        progress.done();
    }

    private static void copyFileUsingChannel(File source, File dest) throws IOException {
        AbstractInterruptibleChannel sourceChannel = null;
        AbstractInterruptibleChannel destChannel = null;
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            if (dest != null && source != null) {
                inputStream = new FileInputStream(source);
                sourceChannel = inputStream.getChannel();
                outputStream = new FileOutputStream(dest);
                destChannel = outputStream.getChannel();
                ((FileChannel)destChannel).transferFrom((ReadableByteChannel)((Object)sourceChannel), 0L, ((FileChannel)sourceChannel).size());
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (sourceChannel != null) {
                sourceChannel.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
            if (destChannel != null) {
                destChannel.close();
            }
        }
    }
}

