/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.update;

import fr.cnav.autocontrole.update.Activator;
import fr.cnav.autocontrole.update.Messages;
import fr.cnav.autocontrole.update.UpdateException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.osgi.framework.ServiceReference;

public class ProvisonningProductService {
    private String updateSiteURL;

    public ProvisonningProductService(String updateSiteURL) {
        this.updateSiteURL = updateSiteURL;
    }

    private IProvisioningAgent setupAgent(URI location) throws ProvisionException {
        IProvisioningAgent agent = null;
        ServiceReference providerRef = Activator.getDefault().getContext().getServiceReference(IProvisioningAgentProvider.SERVICE_NAME);
        if (providerRef == null) {
            throw new RuntimeException("No provisioning agent provider is available");
        }
        IProvisioningAgentProvider provider = (IProvisioningAgentProvider)Activator.getDefault().getContext().getService(providerRef);
        if (provider == null) {
            throw new RuntimeException("No provisioning agent provider is available");
        }
        agent = provider.createAgent(location);
        Activator.getDefault().getContext().ungetService(providerRef);
        return agent;
    }

    private IMetadataRepository loadRepository(IProvisioningAgent agent, URI repositoryLocation) throws ProvisionException, OperationCanceledException {
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        IMetadataRepository repository = manager.loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
        return repository;
    }

    public boolean isUpdateSite() throws UpdateException {
        URI uri = null;
        if (this.updateSiteURL == null) {
            throw new UpdateException(0, Messages.EmptyURI_0);
        }
        try {
            uri = new URI(this.updateSiteURL);
        }
        catch (URISyntaxException e) {
            throw new UpdateException(4, String.valueOf(Messages.IncorrectURI_0) + this.updateSiteURL, e);
        }
        catch (IllegalArgumentException e) {
            if (this.updateSiteURL.trim() == "") {
                throw new UpdateException(1, Messages.EmptyURI_0, e);
            }
            throw new UpdateException(1, String.valueOf(Messages.IncorrectURI_0) + this.updateSiteURL, e);
        }
        try {
            IProvisioningAgent agent = this.setupAgent(null);
            IMetadataRepository repository = this.loadRepository(agent, uri);
            repository.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor());
            return true;
        }
        catch (ProvisionException e) {
            throw new UpdateException(5, String.valueOf(Messages.UndefinedURI_0) + this.updateSiteURL, e);
        }
        catch (IllegalArgumentException e) {
            if (this.updateSiteURL == null || "".equals(this.updateSiteURL.trim())) {
                throw new UpdateException(1, Messages.EmptyURI_0, e);
            }
            throw new UpdateException(1, String.valueOf(Messages.IncorrectURI_0) + this.updateSiteURL, e);
        }
    }
}

