/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.action;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.sirius.viewpoint.Messages;

public abstract class AbstractExternalJavaAction
implements IExternalJavaAction {
    protected <T> T getParameter(Map<String, Object> parameters, String name, Class<T> type) {
        return this.getParameter(parameters, name, type, true);
    }

    protected <T> T getOptionalParameter(Map<String, Object> parameters, String name, Class<T> type) {
        return this.getParameter(parameters, name, type, false);
    }

    private <T> T getParameter(Map<String, Object> parameters, String name, Class<T> type, boolean required) {
        T result;
        if (required && !parameters.containsKey(name)) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.AbstractExternalJavaAction_parameterErrorMsg, name, this.getClass().getName()));
        }
        Object value = parameters.get(name);
        if (type.isInstance(value)) {
            result = type.cast(value);
        } else if (value == null && !required) {
            result = null;
        } else {
            String typeName = value == null ? Messages.AbstractExternalJavaAction_nullParameter : MessageFormat.format(Messages.AbstractExternalJavaAction_parameterType, value.getClass().getSimpleName());
            throw new IllegalArgumentException(MessageFormat.format(Messages.AbstractExternalJavaAction_parameterTypeErrorMsg, name, type.getSimpleName(), typeName));
        }
        return result;
    }
}

