/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.normselector;

import fr.cnav.autocontrole.AutocontrolPlugin;
import fr.cnav.autocontrole.IMessageUIDescriptor;
import fr.cnav.autocontrole.INormSelector;
import fr.cnav.autocontrole.INormSerializer;
import fr.cnav.autocontrole.INormSerializerFactory;
import fr.cnav.autocontrole.exception.AutoCtrlException;
import fr.cnav.autocontrole.exception.ExceptionKind;
import fr.cnav.autocontrole.helpers.NormSerializerImpl;
import fr.cnav.autocontrole.normselector.MessageUIDescriptorImpl;
import fr.cnav.autocontrole.normselector.SerializerFactoryImpl;
import fr.cnav.saturne.validator.api.AbstractKBDescriptor;
import fr.cnav.saturne.validator.autocontrol.registry.INormAutocontrolExtensionRegistry;
import fr.cnav.saturne.validator.autocontrol.registry.INormAutocontrolRegistryHandler;
import fr.cnav.saturne.validator.autocontrol.registry.impl.NormAutocontrolRegistryHandlerImpl;
import fr.cnav.saturne.validator.registry.INormExtensionRegistry;
import fr.cnav.saturne.validator.registry.INormRegistryHandler;
import fr.cnav.saturne.validator.registry.INormSerializerRegistry;
import fr.cnav.saturne.validator.registry.NormRegistryException;
import fr.cnav.saturne.validator.registry.norm.impl.NormRegistryHandlerImpl;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class NormSelectorImpl
implements INormSelector {
    private INormAutocontrolRegistryHandler autocontrolRegistryHandler = new NormAutocontrolRegistryHandlerImpl();
    private INormRegistryHandler normRegistryHandler = new NormRegistryHandlerImpl();
    private INormAutocontrolExtensionRegistry normAutocontrolExtension;
    private INormExtensionRegistry normValidationExtension;
    private AbstractKBDescriptor normDescriptor;
    private INormSerializerFactory serializerFactory;
    private IMessageUIDescriptor messageUIDescriptor;
    private String selectedNormId;
    private URL autocontrol16x16IconURL;
    private URL autocontrol64x64IconURL;
    private URL autocontrolUserDocumentationURL;

    @Override
    public Set<String> getNormIds() {
        return this.normRegistryHandler.getNormIdentifiers();
    }

    @Override
    public INormSerializerFactory getSerializerFactory() throws NormRegistryException {
        if (this.serializerFactory == null) {
            HashMap<String, INormSerializer> contentTypeToReportSerializerMap = new HashMap<String, INormSerializer>();
            for (INormSerializerRegistry iNormSerializerGlobalParameter : this.normValidationExtension.getNormSerializerRegistry()) {
                contentTypeToReportSerializerMap.put(iNormSerializerGlobalParameter.getContentType(), new NormSerializerImpl(iNormSerializerGlobalParameter.getLabel(), iNormSerializerGlobalParameter.getContentType(), iNormSerializerGlobalParameter.getExtension(), iNormSerializerGlobalParameter.getNewIReportSerializer()));
            }
            String defaultSerializer = null;
            if (this.normAutocontrolExtension != null) {
                defaultSerializer = this.normAutocontrolExtension.getDefaultSerializerRegistry().getDefaultSerializerContentType();
            }
            this.serializerFactory = new SerializerFactoryImpl(contentTypeToReportSerializerMap, defaultSerializer);
        }
        return this.serializerFactory;
    }

    @Override
    public AbstractKBDescriptor getNormDescriptor() throws NormRegistryException {
        this.normDescriptor = this.normValidationExtension.getNewINormDescriptor();
        return this.normDescriptor;
    }

    @Override
    public IMessageUIDescriptor getMessageUIDescriptor() {
        if (this.messageUIDescriptor == null && this.normAutocontrolExtension != null) {
            this.messageUIDescriptor = new MessageUIDescriptorImpl(this.normAutocontrolExtension.getIndividualRegistry().getIndividualFullQualifiedID(), this.normAutocontrolExtension.getIndividualRegistry().getIndividualLabel(), this.normAutocontrolExtension.getIndividualRegistry().getIndividualFieldsList());
        }
        return this.messageUIDescriptor;
    }

    @Override
    public void setSelectedNorm(String normId) throws AutoCtrlException {
        this.normDescriptor = null;
        this.messageUIDescriptor = null;
        this.serializerFactory = null;
        this.normValidationExtension = null;
        this.normAutocontrolExtension = null;
        this.selectedNormId = null;
        if (this.isEmpty()) {
            throw new AutoCtrlException(ExceptionKind.ERROR_NO_NORMS_REGISTERED);
        }
        if (!this.normRegistryHandler.getNormIdentifiers().contains(normId)) {
            String normIdException = normId;
            if (normId == null) {
                normIdException = "no id provided";
            }
            StringBuilder normList = new StringBuilder();
            for (String normIdTemp : this.normRegistryHandler.getNormIdentifiers()) {
                normList.append("\n" + normIdTemp + "-" + this.normRegistryHandler.getNormExtension(normIdTemp).getNormLabel());
            }
            throw new AutoCtrlException(normList.toString(), ExceptionKind.CANNOT_SELECT_GIVEN_NORM, normIdException);
        }
        this.selectedNormId = normId;
        this.normAutocontrolExtension = this.autocontrolRegistryHandler.getAutocontrolExtension(normId);
        this.normValidationExtension = this.normRegistryHandler.getNormExtension(normId);
    }

    @Override
    public boolean isEmpty() {
        return this.normRegistryHandler.getNormIdentifiers().size() == 0;
    }

    @Override
    public String getCurrentNormIdUsed() {
        return this.selectedNormId;
    }

    @Override
    public String getNormLabel(String normIdTemp) {
        if (normIdTemp != null) {
            Set normIdentifiers = this.normRegistryHandler.getNormIdentifiers();
            for (String normId : normIdentifiers) {
                INormExtensionRegistry validationExtension = this.normRegistryHandler.getNormExtension(normId);
                if (!normIdTemp.equals(validationExtension.getNormId())) continue;
                return validationExtension.getNormLabel();
            }
        }
        return null;
    }

    @Override
    public String getNormLabel() {
        if (this.normValidationExtension != null) {
            return this.normValidationExtension.getNormLabel();
        }
        return null;
    }

    @Override
    public String getApplicationLabel() {
        if (this.normAutocontrolExtension != null && this.normAutocontrolExtension.getApplicationRegistry() != null) {
            return this.normAutocontrolExtension.getApplicationRegistry().getApplicationNameLabel();
        }
        return null;
    }

    @Override
    public URL getApplicationIcon16x16URL() {
        String applicationIconPath;
        if (this.normAutocontrolExtension != null && this.autocontrol16x16IconURL == null && this.normAutocontrolExtension.getApplicationRegistry() != null && (applicationIconPath = this.normAutocontrolExtension.getApplicationRegistry().getApplicationIcon16Path()) != null) {
            Bundle bundle = this.normAutocontrolExtension.getApplicationRegistry().getBundle();
            this.autocontrol16x16IconURL = FileLocator.find((Bundle)bundle, (IPath)new Path(applicationIconPath), null);
            if (this.autocontrol16x16IconURL == null) {
                AutocontrolPlugin.log((IStatus)new Status(1, "fr.cnav.autocontrole", "No url has been found for the image path '" + applicationIconPath + "'"));
            }
        }
        return this.autocontrol16x16IconURL;
    }

    @Override
    public URL getApplicationIcon64x64URL() {
        String applicationIconPath;
        if (this.normAutocontrolExtension != null && this.autocontrol64x64IconURL == null && this.normAutocontrolExtension.getApplicationRegistry() != null && (applicationIconPath = this.normAutocontrolExtension.getApplicationRegistry().getApplicationIcon64Path()) != null) {
            Bundle bundle = this.normAutocontrolExtension.getApplicationRegistry().getBundle();
            this.autocontrol64x64IconURL = FileLocator.find((Bundle)bundle, (IPath)new Path(applicationIconPath), null);
            if (this.autocontrol64x64IconURL == null) {
                AutocontrolPlugin.log((IStatus)new Status(1, "fr.cnav.autocontrole", "No url has been found for the image path '" + applicationIconPath + "'"));
            }
        }
        return this.autocontrol64x64IconURL;
    }

    @Override
    public URL getApplicationUserDocumentationURL() {
        String applicationUserDocumentation;
        if (this.normAutocontrolExtension != null && this.autocontrolUserDocumentationURL == null && this.normAutocontrolExtension.getApplicationRegistry() != null && (applicationUserDocumentation = this.normAutocontrolExtension.getApplicationRegistry().getApplicationUserDocumentationPath()) != null) {
            Bundle bundle = this.normAutocontrolExtension.getApplicationRegistry().getBundle();
            this.autocontrolUserDocumentationURL = FileLocator.find((Bundle)bundle, (IPath)new Path(applicationUserDocumentation), null);
            if (this.autocontrolUserDocumentationURL != null) {
                try {
                    this.autocontrolUserDocumentationURL = FileLocator.toFileURL((URL)this.autocontrolUserDocumentationURL);
                }
                catch (IOException iOException) {
                    AutocontrolPlugin.log((IStatus)new Status(2, "fr.cnav.autocontrole", "No url has been found for the user documentation path '" + applicationUserDocumentation + "'"));
                }
            }
            if (this.autocontrolUserDocumentationURL == null) {
                AutocontrolPlugin.log((IStatus)new Status(2, "fr.cnav.autocontrole", "No url has been found for the user documentation path '" + applicationUserDocumentation + "'"));
            }
        }
        return this.autocontrolUserDocumentationURL;
    }
}

