/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.syntax;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import fr.cnav.saturne.NatureType;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.engine.IRule;
import fr.cnav.saturne.validator.engine.IRuleResult;
import fr.cnav.saturne.validator.engine.RuleFailure;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.message.api.IMessageFieldNum;
import fr.cnav.saturne.validator.syntax.AbstractFieldSyntaxControl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Csl02SyntaxControl
extends AbstractFieldSyntaxControl {
    private static final String REG_EXP = "\\-?[0-9]+(\\.[0-9]+)?";
    private final Automaton regexpPattern = new RegExp("\\-?[0-9]+(\\.[0-9]+)?").toAutomaton();
    private final NatureType nature;
    private final String fullQualifiedId;

    public Csl02SyntaxControl(int id, String code, FieldDescription target, String fullQualifiedId, NatureType nature, ControlMessages controlMessage, DeclarationDescription declaration) {
        super(id, code, target, controlMessage, declaration);
        this.nature = nature;
        this.fullQualifiedId = fullQualifiedId;
    }

    @Override
    public List<FieldDescription> getUsedData() {
        if (this.getTarget() instanceof FieldDescription) {
            return Stream.of((FieldDescription)this.getTarget()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        return new ArrayList<FieldDescription>();
    }

    @Override
    public IRuleResult run(IMessageBlock context) {
        if (this.nature.equals((Object)NatureType.NUMERIC)) {
            return super.run(context);
        }
        return IRule.SUCCESS;
    }

    @Override
    public IRuleResult run(IMessageField<?> subject) {
        IRuleResult result = IRule.SUCCESS;
        if (subject instanceof IMessageFieldNum) {
            String value = ((IMessageFieldNum)subject).getOriginalValue();
            if (value == null || "".equals(value)) {
                result = IRule.SUCCESS;
            } else if (!this.regexpPattern.run(value)) {
                String message = this.controlMessage.getMessage("syntactic.messages.CSL02_NATURE", new Object[]{this.fullQualifiedId});
                result = new RuleFailure(this, subject, subject.getParent(), message);
            }
        }
        return result;
    }
}

