/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.report.impl;

import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.report.model.Context;
import fr.cnav.saturne.report.model.ContextField;
import fr.cnav.saturne.validator.conversion.xml.XMLFormattingException;
import fr.cnav.saturne.validator.conversion.xml.XMLFormattingWriter;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.SerializationException;
import fr.cnav.saturne.validator.report.impl.AbstractReportSerializerHandler;
import fr.cnav.saturne.validator.report.impl.ReportContextDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class GenericXMLReportSerializerHandler
extends AbstractReportSerializerHandler {
    private static final String EMPTY_STRING = "";
    protected String nameSpacePrefix;
    protected String nameSpace;
    protected String messageName;
    protected Optional<String> nomenclatureVersion = Optional.empty();
    protected XMLFormattingWriter writer;
    private static final String SEPARATOR = "_";
    private static final String CONTEXT_RESULT_SUFFIX_LABEL = "bilan";
    private static final String VALIDATION_VALIDITY_SUFFIX_LABEL = "etat";
    private static final String VALIDITY_RESULT_LABEL = "OK";
    private static final String NO_VALIDITY_RESULT_LABEL = "KO";
    private static final String RANK_LABEL = "rang";
    private static final String SUB_CONTEXT_CONTENT_SUFFIX_LABEL = "contenu";
    private static final String COUNTER_SUFFIX_LABEL = "compteurs";
    private static final String TYPE_TAG = "type";
    private static final String SUB_CONTEXT_NUMBER_SUFFIX_LABEL = "number";
    private static final String BLOCKING_ANOMALIES_LABEL = "anomalies bloquantes";
    private static final String NUMBER_TAG = "nombre";
    private static final String TOTAL_BLOCKING_ANOMALIES_LABEL = "total anomalies bloquantes";
    private static final String TOTAL_NO_BLOCKING_ANOMALIES_LABEL = "total anomalies non bloquantes";
    private static final String NO_BLOCKING_ANOMALIES_LABEL = "anomalies non bloquantes";
    private static final String TOTAL_ANOMALIES_LABEL = "total anomalies";
    private static final String CONTEXT_INFORMATION_SUFFIX_LABEL = "identification";
    private static final String ANOMALIES_SUFFIX_LABEL = "anomalie";
    private static final String ANOMALIES_DESCRIPTION_LABEL = "description";
    private static final String ANOMALIES_CODE_LABEL = "code";
    private static final String ANOMALIES_CATEGORY_LABEL = "categorie";
    private static final String ANOMALIES_MESSAGE_LABEL = "message";
    private static final String ANOMALIES_LINE_NUMBER_LABEL = "numero_ligne";
    private static final String ANOMALIES_CATEGORY_ID_LABEL = "identifiant";
    private static final String ANOMALIES_CATEGORY__LABEL_LABEL = "libelle";
    private static final String ANOMALIES_CATEGORY_VALUE_LABEL = "valeur";
    private static final String ANOMALIES_TARGET_FIELD_LABEL = "rubrique_declenchante";
    private static final String ANOMALIES__NUMBER_LABEL = "nombre";
    private static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    private ReportContextDescriptor reportContextDescriptor;

    public GenericXMLReportSerializerHandler(IReportLogger reportLogger, String namespacePrefix, String namespace, String messageName, OutputStream outputStream, String encoding) throws SerializationException {
        this.init(reportLogger, namespacePrefix, namespace, messageName);
        if (outputStream == null) {
            throw new IllegalArgumentException("The output stream should not be null. The serialization will not be realized.");
        }
        this.initializeWriter(outputStream, encoding == null ? DEFAULT_CHARACTER_ENCODING : encoding);
    }

    public GenericXMLReportSerializerHandler(IReportLogger reportLogger, String namespacePrefix, String namespace, String messageName, Optional<String> nomenclatureVersion, OutputStream outputStream, String encoding) throws SerializationException {
        this(reportLogger, namespacePrefix, namespace, messageName, outputStream, encoding);
        this.nomenclatureVersion = nomenclatureVersion;
    }

    public GenericXMLReportSerializerHandler(IReportLogger reportLogger, String namespacePrefix, String namespace, String messageName, XMLFormattingWriter writer) throws SerializationException {
        this.init(reportLogger, namespacePrefix, namespace, messageName);
        this.writer = writer;
    }

    void init(IReportLogger reportLogger, String namespacePrefix, String namespace, String msgName) {
        if (reportLogger == null) {
            throw new IllegalArgumentException("The report logger must not be null.");
        }
        this.nameSpacePrefix = namespacePrefix;
        this.reportContextDescriptor = reportLogger.geReportContextDescriptor();
        if (this.nameSpacePrefix == null) {
            this.nameSpacePrefix = EMPTY_STRING;
        }
        this.nameSpace = namespace;
        if (this.nameSpace == null) {
            this.nameSpace = EMPTY_STRING;
        }
        this.messageName = msgName.replaceAll(" ", SEPARATOR);
    }

    private void initializeWriter(OutputStream outputStream, String encoding) throws SerializationException {
        try {
            this.writer = new XMLFormattingWriter(outputStream, encoding, "\t", "\n", "1.0", true);
        }
        catch (XMLFormattingException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public void beginSerialization() throws SerializationException {
        try {
            this.writer.writeStartDocument();
            if (this.nomenclatureVersion.isPresent()) {
                this.writer.writeComment("Version Nomenclature : " + this.nomenclatureVersion.get());
            }
            this.writer.setPrefix(this.nameSpacePrefix, this.nameSpace);
            this.writer.writeStartElement(this.nameSpace, this.messageName);
            this.writer.writeNamespace(this.nameSpacePrefix, this.nameSpace);
        }
        catch (XMLFormattingException exception) {
            throw new SerializationException("An exception has occurred while appending the header of the converted file using: nameSpace = " + this.nameSpace + "nameSpacePrefix = " + this.nameSpacePrefix + "messageName = " + this.messageName + ". " + exception.getMessage(), exception);
        }
    }

    @Override
    public void endSerialization() throws SerializationException {
        try {
            this.writer.writeEndElement(true, true);
            this.writer.writeEndDocument();
            this.writer.flush();
        }
        catch (XMLFormattingException exception) {
            throw new SerializationException("An exception has occurred while appending the footer of the converted file: " + exception.getMessage(), exception);
        }
        catch (IOException e) {
            throw new SerializationException("An exception has occurred while appending the footer of the converted file: " + e.getMessage(), e);
        }
    }

    protected List<Anomaly> getAnomalies(Context context) {
        return context.getAnomalies();
    }

    private void serializeAnomalies(Context context) throws XMLFormattingException {
        List<Anomaly> anomalies = this.getAnomalies(context);
        for (Anomaly anomaly : anomalies) {
            this.writer.writeEndOfLine();
            this.writer.writeStartElement(this.nameSpace, String.valueOf(context.getName()) + SEPARATOR + ANOMALIES_SUFFIX_LABEL);
            this.writer.writeStartElement(this.nameSpace, ANOMALIES_DESCRIPTION_LABEL);
            this.writer.writeStartElement(this.nameSpace, ANOMALIES_CODE_LABEL);
            this.writeCharactersAndNullValue(anomaly.getCode());
            this.writer.writeEndElement(false, false);
            this.writer.writeStartElement(this.nameSpace, ANOMALIES_CATEGORY_LABEL);
            this.writeCharactersAndNullValue(anomaly.isBlocking() ? "bloquant" : "non bloquant");
            this.writer.writeEndElement(false, false);
            this.writer.writeStartElement(this.nameSpace, ANOMALIES_MESSAGE_LABEL);
            this.writeCharactersAndNullValue(anomaly.getMessage());
            this.writer.writeEndElement(false, false);
            this.writer.writeStartElement(this.nameSpace, ANOMALIES_LINE_NUMBER_LABEL);
            this.writeCharactersAndNullValue(String.valueOf(anomaly.getFieldLocalizer().getLineNumber()));
            this.writer.writeEndElement(false, false);
            this.writer.writeStartElement(this.nameSpace, "nombre");
            this.writeCharactersAndNullValue(String.valueOf(anomaly.getNumber()));
            this.writer.writeEndElement(false, false);
            this.writer.writeEndElement(true, true);
            this.writer.writeStartElement(this.nameSpace, ANOMALIES_TARGET_FIELD_LABEL);
            this.writer.writeStartElement(this.nameSpace, ANOMALIES_CATEGORY_ID_LABEL);
            this.writeCharactersAndNullValue(anomaly.getFieldId());
            this.writer.writeEndElement(false, false);
            this.writer.writeStartElement(this.nameSpace, ANOMALIES_CATEGORY__LABEL_LABEL);
            this.writeCharactersAndNullValue(anomaly.getFieldLabel());
            this.writer.writeEndElement(false, false);
            this.writer.writeStartElement(this.nameSpace, ANOMALIES_CATEGORY_VALUE_LABEL);
            this.writeCharactersAndNullValue(anomaly.getFieldValue());
            this.writer.writeEndElement(false, false);
            this.writer.writeEndElement(true, true);
            this.writer.writeEndElement(true, true);
        }
    }

    private void writeCharactersAndNullValue(String text) throws XMLFormattingException {
        if (text != null) {
            this.writer.writeCharacters(text);
        } else {
            this.writer.writeCharacters(EMPTY_STRING);
        }
    }

    private void serializeContextInformation(Context context) throws XMLFormattingException {
        this.writer.writeStartElement(this.nameSpace, String.valueOf(context.getName()) + SEPARATOR + CONTEXT_INFORMATION_SUFFIX_LABEL);
        List<ContextField> contextFields = context.getContextFields();
        for (ContextField contextField : contextFields) {
            this.writer.writeStartElement(this.nameSpace, contextField.getReportSerializationName());
            this.writeCharactersAndNullValue(contextField.getValue());
            this.writer.writeEndElement(false, false);
        }
        this.writer.writeEndElement(true, true);
    }

    private void serializeAssessment(Context context) throws XMLFormattingException {
        this.writer.writeStartElement(this.nameSpace, String.valueOf(context.getName()) + SEPARATOR + CONTEXT_RESULT_SUFFIX_LABEL);
        this.writer.writeStartElement(this.nameSpace, VALIDATION_VALIDITY_SUFFIX_LABEL);
        if (context.isValid()) {
            this.writeCharactersAndNullValue(VALIDITY_RESULT_LABEL);
        } else {
            this.writeCharactersAndNullValue(NO_VALIDITY_RESULT_LABEL);
        }
        this.writer.writeEndElement(false, false);
        this.writer.writeStartElement(this.nameSpace, RANK_LABEL);
        this.writeCharactersAndNullValue(String.valueOf(context.getRank()));
        this.writer.writeEndElement(false, false);
        this.writer.writeStartElement(this.nameSpace, String.valueOf(context.getName()) + SEPARATOR + SUB_CONTEXT_CONTENT_SUFFIX_LABEL);
        Map<String, Integer> contextSerialisationNameToContextNumber = this.calculateSubContextNumber(context);
        Set<Map.Entry<String, Integer>> entrySet = contextSerialisationNameToContextNumber.entrySet();
        for (Map.Entry<String, Integer> entry : entrySet) {
            this.writer.writeStartElement(this.nameSpace, String.valueOf(entry.getKey()) + SEPARATOR + SUB_CONTEXT_NUMBER_SUFFIX_LABEL);
            this.writeCharactersAndNullValue(String.valueOf(entry.getValue()));
            this.writer.writeEndElement(false, false);
        }
        this.writer.writeEndElement(true, true);
        if (context.doUseTotalAnomaliesCounter()) {
            this.writer.writeStartElement(this.nameSpace, COUNTER_SUFFIX_LABEL);
            this.writer.writeStartElement(this.nameSpace, TYPE_TAG);
            this.writeCharactersAndNullValue(TOTAL_NO_BLOCKING_ANOMALIES_LABEL);
            this.writer.writeEndElement(false, false);
            this.writer.writeStartElement(this.nameSpace, "nombre");
            this.writeCharactersAndNullValue(String.valueOf(this.getNoBlockingAnomaliesNumber(context)));
            this.writer.writeEndElement(false, false);
            this.writer.writeEndElement(true, true);
            this.writer.writeStartElement(this.nameSpace, COUNTER_SUFFIX_LABEL);
            this.writer.writeStartElement(this.nameSpace, TYPE_TAG);
            this.writeCharactersAndNullValue(TOTAL_ANOMALIES_LABEL);
            this.writer.writeEndElement(false, false);
            this.writer.writeStartElement(this.nameSpace, "nombre");
            this.writeCharactersAndNullValue(String.valueOf(this.getTotalAnomaliesNumber(context)));
            this.writer.writeEndElement(false, false);
            this.writer.writeEndElement(true, true);
            this.writer.writeStartElement(this.nameSpace, COUNTER_SUFFIX_LABEL);
            this.writer.writeStartElement(this.nameSpace, TYPE_TAG);
            this.writeCharactersAndNullValue(TOTAL_BLOCKING_ANOMALIES_LABEL);
            this.writer.writeEndElement(false, false);
            this.writer.writeStartElement(this.nameSpace, "nombre");
            this.writeCharactersAndNullValue(String.valueOf(this.getTotalBlockingAnomaliesNumber(context)));
            this.writer.writeEndElement(false, false);
            this.writer.writeEndElement(true, true);
        }
        if (context.doUseAnomaliesCounter()) {
            this.writer.writeStartElement(this.nameSpace, COUNTER_SUFFIX_LABEL);
            this.writer.writeStartElement(this.nameSpace, TYPE_TAG);
            this.writeCharactersAndNullValue(NO_BLOCKING_ANOMALIES_LABEL);
            this.writer.writeEndElement(false, false);
            this.writer.writeStartElement(this.nameSpace, "nombre");
            this.writeCharactersAndNullValue(String.valueOf(this.getTotalNoBlockingAnomalies(context)));
            this.writer.writeEndElement(false, false);
            this.writer.writeEndElement(true, true);
            this.writer.writeStartElement(this.nameSpace, COUNTER_SUFFIX_LABEL);
            this.writer.writeStartElement(this.nameSpace, TYPE_TAG);
            this.writeCharactersAndNullValue(BLOCKING_ANOMALIES_LABEL);
            this.writer.writeEndElement(false, false);
            this.writer.writeStartElement(this.nameSpace, "nombre");
            this.writeCharactersAndNullValue(String.valueOf(this.getBlockingAnomaliesNumber(context)));
            this.writer.writeEndElement(false, false);
            this.writer.writeEndElement(true, true);
        }
        this.writer.writeEndElement(true, true);
    }

    private int getTotalAnomaliesNumber(Context context) {
        List<Context> contextChildren = context.getContextChildren();
        int anomaliesNumber = 0;
        for (Anomaly anomaly : context.getAnomalies()) {
            anomaliesNumber += anomaly.getNumber();
        }
        for (Context contextChild : contextChildren) {
            anomaliesNumber += this.getTotalAnomaliesNumber(contextChild);
        }
        return anomaliesNumber;
    }

    private int getTotalNoBlockingAnomalies(Context context) {
        List<Context> contextChildren = context.getContextChildren();
        int anomaliesNumber = this.getNoBlockingAnomaliesNumber(context);
        for (Context contextChild : contextChildren) {
            anomaliesNumber += this.getTotalNoBlockingAnomalies(contextChild);
        }
        return anomaliesNumber;
    }

    private int getTotalBlockingAnomaliesNumber(Context context) {
        List<Context> contextChildren = context.getContextChildren();
        int anomaliesNumber = this.getBlockingAnomaliesNumber(context);
        for (Context contextChild : contextChildren) {
            anomaliesNumber += this.getTotalBlockingAnomaliesNumber(contextChild);
        }
        return anomaliesNumber;
    }

    private int getNoBlockingAnomaliesNumber(Context context) {
        List<Anomaly> anomalies = context.getAnomalies();
        int noBlockingAnomaliesNumber = 0;
        for (Anomaly anomaly : anomalies) {
            if (anomaly.isBlocking()) continue;
            noBlockingAnomaliesNumber += anomaly.getNumber();
        }
        return noBlockingAnomaliesNumber;
    }

    private int getBlockingAnomaliesNumber(Context context) {
        List<Anomaly> anomalies = context.getAnomalies();
        int blockingAnomaliesNumber = 0;
        for (Anomaly anomaly : anomalies) {
            if (!anomaly.isBlocking()) continue;
            blockingAnomaliesNumber += anomaly.getNumber();
        }
        return blockingAnomaliesNumber;
    }

    private Map<String, Integer> calculateSubContextNumber(Context context) {
        List<Context> contextChildren = context.getContextChildren();
        HashMap<String, Integer> contextSerialisationNameToContextNumber = new HashMap<String, Integer>();
        Set<String> directSubContextSerializationNames = this.reportContextDescriptor.getDirectSubContextSerializationNames(context);
        if (directSubContextSerializationNames == null) {
            throw new IllegalArgumentException("A context should have a serialization name.");
        }
        for (String directSubContextSerializationName : directSubContextSerializationNames) {
            contextSerialisationNameToContextNumber.put(directSubContextSerializationName, 0);
        }
        for (Context subcontext : contextChildren) {
            Integer subContextNumber = (Integer)contextSerialisationNameToContextNumber.get(subcontext.getName());
            if (subContextNumber == null) continue;
            subContextNumber = subContextNumber + 1;
            contextSerialisationNameToContextNumber.put(subcontext.getName(), subContextNumber);
        }
        return contextSerialisationNameToContextNumber;
    }

    @Override
    public void pushContext(Context context) throws SerializationException {
        try {
            this.writer.writeStartElement(this.nameSpace, context.getName());
            this.serializeContextInformation(context);
            this.serializeAssessment(context);
            this.serializeAnomalies(context);
        }
        catch (XMLFormattingException e) {
            throw new SerializationException("An exception has occurred while appending serializing the validation information." + e.getMessage(), e);
        }
    }

    @Override
    public void popContext() throws SerializationException {
        try {
            this.writer.writeEndElement(true, true);
        }
        catch (XMLFormattingException exception) {
            throw new SerializationException(exception);
        }
    }
}

