/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.positional.csv;

import fr.cnav.saturne.validator.positional.csv.CsvInfo;
import fr.cnav.saturne.validator.positional.csv.CsvProblemSeverity;
import fr.cnav.saturne.validator.positional.csv.IValidationRule;
import fr.cnav.saturne.validator.positional.csv.ValidationResult;
import java.util.List;

public class Validator {
    private List<IValidationRule> rules;

    public Validator(List<IValidationRule> rules) {
        if (rules == null) {
            throw new IllegalArgumentException("The rules list cannot be null.");
        }
        this.rules = rules;
    }

    public ValidationResult validate(String[] line, String lineId) {
        StringBuilder message = new StringBuilder();
        boolean first = true;
        boolean mustForbidImport = false;
        for (IValidationRule rule : this.rules) {
            CsvInfo log = rule.validate(line);
            if (log == null) continue;
            if (!first) {
                message.append('\n');
            } else {
                first = false;
            }
            message.append(log.getLevel().name()).append('!').append(' ');
            if (log.getColumnId() != null) {
                message.append('(').append(log.getColumnId()).append(')').append(' ');
            }
            message.append(log.getMessage());
            if (!CsvProblemSeverity.FATAL.equals((Object)log.getLevel())) continue;
            mustForbidImport = true;
        }
        String strMessage = message.toString();
        return new ValidationResult(strMessage.isEmpty(), strMessage, lineId, mustForbidImport);
    }
}

