/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.positional.csv;

import fr.cnav.saturne.validator.positional.csv.ICSVParameters;
import java.util.regex.Pattern;

public class FixedCSVParameters
implements ICSVParameters {
    private final String columnSeparator;
    private final String columnDelimiter;
    private final String quotedColumnDelimiter;
    private final String doubledColumnDelimiter;
    private final String encoding;
    private final Boolean hasTitleLine;

    public FixedCSVParameters(String columnSeparator, String columnDelimiter, String encoding, Boolean hasTitleLine) {
        if (columnDelimiter == null) {
            throw new IllegalArgumentException("The Column delimiter cannot be null");
        }
        if (hasTitleLine == null) {
            throw new IllegalArgumentException("The title condition cannot be null");
        }
        this.columnSeparator = columnSeparator;
        this.columnDelimiter = columnDelimiter;
        this.quotedColumnDelimiter = Pattern.quote(columnDelimiter);
        this.doubledColumnDelimiter = String.valueOf(columnDelimiter) + columnDelimiter;
        this.encoding = encoding;
        this.hasTitleLine = hasTitleLine;
    }

    @Override
    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    @Override
    public String getColumnDelimiter() {
        return this.columnDelimiter;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getDoubledColumnDelimiter() {
        return this.doubledColumnDelimiter;
    }

    @Override
    public String getQuotedColumnDelimiter() {
        return this.quotedColumnDelimiter;
    }

    @Override
    public boolean hasTitleLine() {
        return this.hasTitleLine;
    }
}

