/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.message;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.MessageElement;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.dsl.requestor.StandardNavigationException;
import fr.cnav.saturne.utils.BlockDeepestAncetorExtractor;
import fr.cnav.saturne.utils.BlockUtil;
import fr.cnav.saturne.utils.CardinalityExtractor;
import fr.cnav.saturne.utils.FieldUtil;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageElement;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.message.api.IMessageNavigator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MessageNavigator
implements IMessageNavigator {
    private StandardAccessor standardAccessor;
    private BlockUtil blockUtil = new BlockUtil();
    private FieldUtil fieldUtil;

    public MessageNavigator(StandardAccessor theStandardAccessor) {
        this.standardAccessor = theStandardAccessor;
        this.fieldUtil = new FieldUtil();
    }

    @Override
    public List<IMessageElement> getTargetMessages(IMessageBlock context, String targetFullQualifiedId) throws StandardNavigationException {
        Objects.requireNonNull(context);
        Objects.requireNonNull(targetFullQualifiedId);
        Block sourceBlock = this.standardAccessor.getBlock(context.getStandardBlockDescription().getFullQualifiedId());
        Block targetBlock = this.getTargetBlock(targetFullQualifiedId);
        IMessageBlock currentAnsestor = context;
        if (sourceBlock != null && targetBlock != null) {
            BlockDeepestAncetorExtractor blockDeepestAncetorExtractor = new BlockDeepestAncetorExtractor((MessageElement)sourceBlock, (MessageElement)targetBlock);
            currentAnsestor = this.getMessageBlockAncestor(currentAnsestor, blockDeepestAncetorExtractor);
            List<IMessageBlock> targets = this.getAllTargetsFromDeepestAncestor(currentAnsestor, blockDeepestAncetorExtractor);
            ArrayList<IMessageElement> result = new ArrayList<IMessageElement>();
            for (IMessageBlock msgBlock : targets) {
                Field targetField = this.standardAccessor.getField(targetFullQualifiedId);
                if (targetField == null) {
                    result.add(msgBlock);
                    continue;
                }
                IMessageField<?> msgField = msgBlock.getField(this.fieldUtil.indexOfField(targetField));
                if (msgField == null) continue;
                result.add(msgField);
            }
            return result;
        }
        if (sourceBlock != null) {
            throw new StandardNavigationException("We could not found context block for " + context.getStandardBlockDescription().getFullQualifiedId() + " Full Qualified Id  in standard.");
        }
        if (targetBlock != null) {
            throw new StandardNavigationException("We could not found target Message element for " + context.getStandardBlockDescription().getFullQualifiedId() + " Full Qualified Id in standard.");
        }
        return null;
    }

    @Override
    public Boolean isMultipleTarget(IMessageBlock context, String targetFullQualifiedId) throws StandardNavigationException {
        Block sourceBlock = this.standardAccessor.getBlock(context.getStandardBlockDescription().getFullQualifiedId());
        Block targetBlock = this.getTargetBlock(targetFullQualifiedId);
        if (sourceBlock != null && targetBlock != null) {
            CardinalityExtractor cardinalityExtractor = new CardinalityExtractor((MessageElement)sourceBlock, (MessageElement)targetBlock);
            return cardinalityExtractor.isMultiple();
        }
        if (sourceBlock != null) {
            throw new StandardNavigationException("We could not found context block for " + context.getStandardBlockDescription().getFullQualifiedId() + " Full Qualified Id  in standard.");
        }
        if (targetBlock != null) {
            throw new StandardNavigationException("We could not found target Message element for " + context.getStandardBlockDescription().getFullQualifiedId() + " Full Qualified Id in standard.");
        }
        return false;
    }

    private List<IMessageBlock> getAllTargetsFromDeepestAncestor(IMessageBlock currentAnsestor, BlockDeepestAncetorExtractor blockDeepestAncetorExtractor) throws StandardNavigationException {
        List<IMessageBlock> nextMsgBlockSearchList = new ArrayList<IMessageBlock>();
        nextMsgBlockSearchList.add(currentAnsestor);
        List blocksFromDeepestAncestorToTgt = blockDeepestAncetorExtractor.getBlocksListFromDeepestAncestorToTgt();
        for (MessageElement block : blocksFromDeepestAncestorToTgt) {
            if (block == blockDeepestAncetorExtractor.getDeepestAncestorBlock()) continue;
            nextMsgBlockSearchList = this.extractMsgEltLstOfTgtBlock(nextMsgBlockSearchList, block);
        }
        return nextMsgBlockSearchList;
    }

    private List<IMessageBlock> extractMsgEltLstOfTgtBlock(List<IMessageBlock> msgEltSearchLst, MessageElement targetBlock) throws StandardNavigationException {
        ArrayList<IMessageBlock> nextStepResult = new ArrayList<IMessageBlock>();
        int idx = this.blockUtil.indexOfBlock(targetBlock);
        for (IMessageBlock currentMsgBlockResult : msgEltSearchLst) {
            List<IMessageBlock> msgBlocksList = currentMsgBlockResult.getBlock(idx);
            for (IMessageBlock msgBlock : msgBlocksList) {
                if (targetBlock.getFullQualifiedId().equals(msgBlock.getStandardBlockDescription().getFullQualifiedId())) continue;
                throw new StandardNavigationException("Wrong Block FullQualifiedId found when we search target.");
            }
            nextStepResult.addAll(msgBlocksList);
        }
        return nextStepResult;
    }

    private IMessageBlock getMessageBlockAncestor(IMessageBlock context, BlockDeepestAncetorExtractor blockDeepestAncetorExtractor) throws StandardNavigationException {
        IMessageBlock deepestAnsestor = null;
        IMessageBlock currentAnsestor = context;
        List blocksFromSrcToDeepestAncestor = blockDeepestAncetorExtractor.getBlocksListFromSrcToDeepestAncestor();
        for (MessageElement block : blocksFromSrcToDeepestAncestor) {
            if (block != blockDeepestAncetorExtractor.getDeepestAncestorBlock()) {
                currentAnsestor = currentAnsestor.getParent();
                continue;
            }
            deepestAnsestor = currentAnsestor;
            break;
        }
        if (deepestAnsestor == null) {
            throw new StandardNavigationException("Can not find valid deepest ansestor Block Message.");
        }
        return currentAnsestor;
    }

    private Block getTargetBlock(String targetFullQualifiedId) {
        Block targetBlock = this.standardAccessor.getBlock(targetFullQualifiedId);
        Field targetField = null;
        if (targetBlock == null && (targetField = this.standardAccessor.getField(targetFullQualifiedId)) != null && targetField.eContainer() != null && targetField.eContainer() instanceof Block) {
            targetBlock = (Block)targetField.eContainer();
        }
        return targetBlock;
    }
}

