/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.message;

import fr.cnav.saturne.Field;
import fr.cnav.saturne.SaturneFactory;
import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DataTypeDescription;
import fr.cnav.saturne.api.model.access.DeclarationBlockDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.HeaderBlockDescription;
import fr.cnav.saturne.api.model.access.IdQualifiedElementDescription;
import fr.cnav.saturne.api.model.access.MessageDescription;
import fr.cnav.saturne.api.model.access.MessageElementDescription;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.api.model.access.StandardMapUtils;
import fr.cnav.saturne.validator.IFieldLocalizer;
import fr.cnav.saturne.validator.message.DeclarationMessageBlock;
import fr.cnav.saturne.validator.message.MessageBlock;
import fr.cnav.saturne.validator.message.MessageField;
import fr.cnav.saturne.validator.message.MessageFieldAlphanum;
import fr.cnav.saturne.validator.message.MessageFieldDate;
import fr.cnav.saturne.validator.message.MessageFieldNum;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.util.Date;

public class MessageElementFactory {
    private DateTimeFormatter dateFormatter;
    private ZoneId defaultZoneId = ZoneId.systemDefault();
    private StandardAccessor standardAccessor;

    public MessageElementFactory(StandardAccessor theStandardAccessor) {
        if (theStandardAccessor == null) {
            throw new IllegalArgumentException("model accessor must not be null.");
        }
        String dateFormat = theStandardAccessor.getStandardDescription().getDateFormat();
        if (dateFormat == null) {
            throw new IllegalArgumentException("date formatter must not be null.");
        }
        this.dateFormatter = DateTimeFormatter.ofPattern(dateFormat.replace('y', 'u')).withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
        this.standardAccessor = theStandardAccessor;
    }

    public MessageBlock getRootContextBlock() {
        HeaderBlockDescription headerBlock = this.standardAccessor.getMessageDescription().getHeaderBlock();
        return new MessageBlock((MessageElementDescription)this.standardAccessor.getMessageDescription(), this.indexOfBlock((BlockDescription)headerBlock), 0, 2);
    }

    public StandardAccessor getStandardAccessor() {
        return this.standardAccessor;
    }

    public int indexOfBlock(BlockDescription block) {
        IdQualifiedElementDescription eContainer = block.getParent();
        int index = -1;
        if (block instanceof HeaderBlockDescription) {
            index = 0;
        } else if (eContainer instanceof MessageDescription) {
            index = 1;
        } else if (eContainer instanceof BlockDescription) {
            index = ((BlockDescription)eContainer).getChildrenBlocks().indexOf(block);
        }
        return index;
    }

    public int indexOfField(FieldDescription field) {
        IdQualifiedElementDescription eContainer = field.getParent();
        int index = -1;
        if (eContainer instanceof BlockDescription) {
            index = ((BlockDescription)eContainer).getFields().indexOf(field);
        }
        return index;
    }

    public MessageField<?> createMessageField(String fullQualifiedId, String originalValue, IFieldLocalizer fieldLocalizer) {
        return this.createMessageField(fullQualifiedId, originalValue, fieldLocalizer, null);
    }

    public MessageField<?> createMessageField(String fullQualifiedId, String originalValue, IFieldLocalizer fieldLocalizer, MessageBlock msgBlockParent) {
        if (fieldLocalizer == null) {
            throw new IllegalArgumentException("Couldn't create the specified message Field " + fullQualifiedId + ". The fieldLocalizer can not be null.");
        }
        FieldDescription field = this.standardAccessor.getFieldDescription(fullQualifiedId);
        if (field != null) {
            MessageField result = null;
            DataTypeDescription type = field.getDataType();
            if (type != null) {
                switch (type.getNature()) {
                    case ALPHANUMERIC: 
                    case ENUMERATION: 
                    case EXTERNAL_REFERENTIAL: {
                        result = new MessageFieldAlphanum(msgBlockParent, field, originalValue, this.indexOfField(field), fieldLocalizer);
                        break;
                    }
                    case DATE: {
                        if (originalValue != null) {
                            Date date;
                            try {
                                LocalDate localDate = LocalDate.parse(originalValue, this.dateFormatter);
                                date = Date.from(localDate.atStartOfDay(this.defaultZoneId).toInstant());
                            }
                            catch (DateTimeParseException dateTimeParseException) {
                                date = null;
                            }
                            result = new MessageFieldDate((IMessageBlock)msgBlockParent, field, originalValue, date, this.indexOfField(field), fieldLocalizer);
                            break;
                        }
                        result = new MessageFieldDate((IMessageBlock)msgBlockParent, field, null, null, this.indexOfField(field), fieldLocalizer);
                        break;
                    }
                    case NUMERIC: {
                        if (originalValue != null) {
                            BigDecimal value;
                            try {
                                value = new BigDecimal(originalValue);
                            }
                            catch (NumberFormatException numberFormatException) {
                                value = new BigDecimal(0);
                            }
                            result = new MessageFieldNum((IMessageBlock)msgBlockParent, field, originalValue, value, this.indexOfField(field), fieldLocalizer);
                            break;
                        }
                        result = new MessageFieldNum((IMessageBlock)msgBlockParent, field, null, null, this.indexOfField(field), fieldLocalizer);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("should never happen");
                    }
                }
            }
            return result;
        }
        return this.createAnonymousMessageField(fullQualifiedId, originalValue, fieldLocalizer);
    }

    public MessageBlock createMessageBlock(String fullQualifiedId) {
        BlockDescription block = this.standardAccessor.getBlockDescription(fullQualifiedId);
        if (block != null) {
            return new MessageBlock((MessageElementDescription)block, this.indexOfBlock(block), block.getFields().size(), block.getChildrenBlocks().size());
        }
        throw new IllegalArgumentException("Couldn't find the specified block : " + fullQualifiedId);
    }

    public DeclarationMessageBlock createDeclarationBlock(String fullQualifiedId, String declarationType) {
        BlockDescription block = this.standardAccessor.getBlockDescription(fullQualifiedId);
        if (block != null && block instanceof DeclarationBlockDescription) {
            return new DeclarationMessageBlock(block, this.indexOfBlock(block), block.getFields().size(), block.getChildrenBlocks().size(), declarationType);
        }
        if (block != null && !(block instanceof DeclarationBlockDescription)) {
            throw new IllegalArgumentException("The specified block : " + fullQualifiedId + " is not a declaration block.");
        }
        throw new IllegalArgumentException("Couldn't find the specified block : " + fullQualifiedId);
    }

    private MessageField<?> createAnonymousMessageField(String fullQualifiedId, String originalValue, IFieldLocalizer fieldLocalizer) {
        Field createdFieldStandard = SaturneFactory.eINSTANCE.createField();
        createdFieldStandard.setId(fullQualifiedId);
        FieldDescription createdField = new FieldDescription(createdFieldStandard, null, new StandardMapUtils());
        return new MessageFieldAlphanum(null, createdField, originalValue, -1, fieldLocalizer);
    }
}

