/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.utils;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.Message;
import fr.cnav.saturne.MessageElement;
import fr.cnav.saturne.NatureType;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.utils.BlockDeepestAncetorExtractor;
import fr.cnav.saturne.validator.message.MessageBuilder;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DefaultMessageCreator {
    private MessageBuilder messageBuilder;

    public DefaultMessageCreator(StandardAccessor standardAccessor) {
        this.messageBuilder = new MessageBuilder(standardAccessor);
    }

    public Optional<IMessageBlock> createDefaultMessage(MessageElement context, List<MessageElement> listMsgElt) {
        Optional<IMessageBlock> rootMsgBlock = Optional.empty();
        HashMap<String, IMessageBlock> mapFqidToCreatedElement = new HashMap<String, IMessageBlock>();
        MessageElement root = context;
        this.messageBuilder.createMessageBlock(root.getFullQualifiedId());
        mapFqidToCreatedElement.put(root.getFullQualifiedId(), this.messageBuilder.getCurrentBlock());
        for (MessageElement target : listMsgElt) {
            BlockDeepestAncetorExtractor blockDeepestAncetorExtractor = new BlockDeepestAncetorExtractor(root, target);
            List pathToSrc = blockDeepestAncetorExtractor.getBlocksListFromDeepestAncestorToSrc();
            List pathToTgt = blockDeepestAncetorExtractor.getBlocksListFromDeepestAncestorToTgt();
            if (!pathToTgt.isEmpty() && ((MessageElement)pathToTgt.get(0)).getFullQualifiedId().equals(root.getFullQualifiedId())) {
                IMessageBlock rootBlock = (IMessageBlock)mapFqidToCreatedElement.get(root.getFullQualifiedId());
                this.messageBuilder.setCurrentBlock(rootBlock);
                this.createNewBranch(pathToTgt, mapFqidToCreatedElement);
                continue;
            }
            if (!pathToSrc.isEmpty() && ((MessageElement)pathToSrc.get(0)).getFullQualifiedId().equals(target.getFullQualifiedId())) {
                this.messageBuilder.createMessageBlock(target.getFullQualifiedId());
                mapFqidToCreatedElement.put(target.getFullQualifiedId(), this.messageBuilder.getCurrentBlock());
                IMessageBlock targetBlock = (IMessageBlock)mapFqidToCreatedElement.get(target.getFullQualifiedId());
                this.messageBuilder.setCurrentBlock(targetBlock);
                this.createNewBranch(pathToSrc, mapFqidToCreatedElement);
                root = target;
                continue;
            }
            if (pathToSrc.isEmpty() || pathToTgt.isEmpty()) continue;
            MessageElement commonAncestor = (MessageElement)pathToSrc.get(0);
            this.messageBuilder.createMessageBlock(commonAncestor.getFullQualifiedId());
            mapFqidToCreatedElement.put(commonAncestor.getFullQualifiedId(), this.messageBuilder.getCurrentBlock());
            IMessageBlock ancestorBlock = (IMessageBlock)mapFqidToCreatedElement.get(commonAncestor.getFullQualifiedId());
            this.messageBuilder.setCurrentBlock(ancestorBlock);
            this.createNewBranch(pathToSrc, mapFqidToCreatedElement);
            this.messageBuilder.setCurrentBlock(ancestorBlock);
            this.createNewBranch(pathToTgt, mapFqidToCreatedElement);
            root = commonAncestor;
        }
        rootMsgBlock = Optional.of((IMessageBlock)mapFqidToCreatedElement.get(root.getFullQualifiedId()));
        return rootMsgBlock;
    }

    protected void createNewBranch(List<MessageElement> path, Map<String, IMessageBlock> mapFqidToCreatedElement) {
        for (MessageElement messageElement : path) {
            IMessageBlock nextCurrentBlock;
            IMessageBlock currentBlock;
            String fqIdmsgElt = messageElement.getFullQualifiedId();
            if (!mapFqidToCreatedElement.containsKey(fqIdmsgElt) && (messageElement instanceof Message || messageElement instanceof Block)) {
                currentBlock = this.messageBuilder.getCurrentBlock();
                this.messageBuilder.createMessageBlock(fqIdmsgElt);
                nextCurrentBlock = this.messageBuilder.getCurrentBlock();
                mapFqidToCreatedElement.put(fqIdmsgElt, this.messageBuilder.getCurrentBlock());
                if (this.containsChildren(currentBlock, fqIdmsgElt)) continue;
                currentBlock.addBlock(nextCurrentBlock);
                continue;
            }
            if (mapFqidToCreatedElement.containsKey(fqIdmsgElt) && (messageElement instanceof Block || messageElement instanceof Message)) {
                currentBlock = this.messageBuilder.getCurrentBlock();
                nextCurrentBlock = mapFqidToCreatedElement.get(fqIdmsgElt);
                if (!currentBlock.getStandardBlockDescription().getFullQualifiedId().equals(fqIdmsgElt) && !this.containsChildren(currentBlock, fqIdmsgElt)) {
                    currentBlock.addBlock(nextCurrentBlock);
                }
                this.messageBuilder.setCurrentBlock(nextCurrentBlock);
                continue;
            }
            if (mapFqidToCreatedElement.containsKey(fqIdmsgElt) || !(messageElement instanceof Field)) continue;
            Field currentField = (Field)messageElement;
            Block parentBlock = (Block)currentField.eContainer();
            IMessageBlock currentBlock2 = mapFqidToCreatedElement.get(parentBlock.getFullQualifiedId());
            this.messageBuilder.setCurrentBlock(currentBlock2);
            this.createDefaultMessageField(currentField);
        }
    }

    protected boolean containsChildren(IMessageBlock parent, String candidateChild) {
        ArrayList<IMessageBlock> allChildren = new ArrayList<IMessageBlock>();
        for (List<IMessageBlock> list : parent.getChildren()) {
            allChildren.addAll(list);
        }
        return allChildren.stream().anyMatch(elem -> elem != null && elem.getStandardBlockDescription().getFullQualifiedId().equals(candidateChild));
    }

    private void createDefaultMessageField(Field field) {
        String value = "";
        if (field.getDataType().getNature() == NatureType.ALPHANUMERIC || field.getDataType().getNature() == NatureType.ENUMERATION || field.getDataType().getNature() == NatureType.EXTERNAL_REFERENTIAL) {
            value = String.valueOf(field.getFullQualifiedId()) + "Value";
        } else if (field.getDataType().getNature() == NatureType.NUMERIC) {
            value = "99";
        } else if (field.getDataType().getNature() == NatureType.DATE) {
            value = "01012001D";
        }
        this.messageBuilder.createMessageFieldInCurrentBlock(field.getFullQualifiedId(), value);
    }

    public static String messageToText(IMessageBlock message, String context) {
        StringBuilder builder = new StringBuilder();
        DefaultMessageCreator.messageToText(message, context, builder, "", 0);
        return builder.toString();
    }

    private static void messageToText(IMessageBlock message, String context, StringBuilder builder, String increment, int counter) {
        int newCounter = counter;
        builder.append(String.valueOf(increment) + "<" + message.getStandardBlockDescription().getFullQualifiedId());
        if (message.getStandardBlockDescription().getFullQualifiedId().equals(context)) {
            builder.append("#context");
        }
        builder.append("\n");
        for (IMessageField<?> iMessageField : message.getFields()) {
            builder.append(String.valueOf(increment) + " +" + iMessageField.getStandardFieldDescription().getFullQualifiedId() + ",{" + newCounter++ + "}" + "\n");
        }
        for (List list : message.getChildren()) {
            for (IMessageBlock block : list) {
                DefaultMessageCreator.messageToText(block, context, builder, String.valueOf(increment) + " ", newCounter);
            }
        }
        builder.append(String.valueOf(increment) + ">\n");
    }
}

