/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.syntax;

import fr.cnav.saturne.NatureType;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.engine.IRule;
import fr.cnav.saturne.validator.syntax.CRESyntaxControl;
import fr.cnav.saturne.validator.syntax.Csl00SyntaxControl;
import fr.cnav.saturne.validator.syntax.Csl01SyntaxControl;
import fr.cnav.saturne.validator.syntax.Csl02SyntaxControl;
import fr.cnav.saturne.validator.syntax.Csl03SyntaxControl;
import fr.cnav.saturne.validator.syntax.Csl04SyntaxControl;
import fr.cnav.saturne.validator.syntax.Csl05SyntaxControl;
import fr.cnav.saturne.validator.syntax.Csl11SyntaxControl;
import fr.cnav.saturne.validator.syntax.Cst04SyntaxControl;
import fr.cnav.saturne.validator.syntax.Cst06SyntaxControl;
import fr.cnav.saturne.validator.syntax.ExceptionKind;
import fr.cnav.saturne.validator.syntax.SyntacticControlCode;
import fr.cnav.saturne.validator.syntax.SyntacticControlException;

public class SyntaxCtrlFieldFactory {
    private final ControlMessages controlMessage;
    private final StandardAccessor modelAccessor;

    public SyntaxCtrlFieldFactory(StandardAccessor modelAccessor, ControlMessages controlMessage) {
        this.controlMessage = controlMessage;
        this.modelAccessor = modelAccessor;
    }

    public IRule getRule(int id, FieldDescription aField, SyntacticControlCode syntaxCtrlKind, DeclarationDescription declaration) {
        IRule result = null;
        if (syntaxCtrlKind == SyntacticControlCode.CSL_00) {
            result = this.getCSL00Rule(id, aField, declaration);
        } else if (syntaxCtrlKind == SyntacticControlCode.CSL_01) {
            result = this.getCSL01Rule(id, aField, declaration);
        } else if (syntaxCtrlKind == SyntacticControlCode.CSL_02) {
            result = this.getCSL02Rule(id, aField, declaration);
        } else if (syntaxCtrlKind == SyntacticControlCode.CSL_03) {
            result = this.getCSL03Rule(id, aField, declaration);
        } else if (syntaxCtrlKind == SyntacticControlCode.CSL_04) {
            result = this.getCSL04Rule(id, aField, declaration);
        } else if (syntaxCtrlKind == SyntacticControlCode.CSL_05) {
            result = this.getCSL05Rule(id, aField, declaration);
        } else if (syntaxCtrlKind == SyntacticControlCode.CSL_11) {
            result = this.getCSL11Rule(id, aField, declaration);
        } else if (syntaxCtrlKind == SyntacticControlCode.CST_04) {
            result = this.getCST04Rule(id, aField, declaration);
        } else if (syntaxCtrlKind == SyntacticControlCode.CST_06) {
            result = this.getCST06Rule(id, aField, declaration);
        } else if (syntaxCtrlKind == SyntacticControlCode.CRE) {
            result = this.getCRERule(id, aField, declaration);
        } else {
            throw new SyntacticControlException(ExceptionKind.UNSUPPORTED_CTRL_RUB, new Object[]{syntaxCtrlKind});
        }
        return result;
    }

    private IRule getCST06Rule(int id, FieldDescription anElement, DeclarationDescription declaration) {
        Cst06SyntaxControl ruleCst06 = new Cst06SyntaxControl(id, SyntacticControlCode.CST_06.getCode(), anElement, this.controlMessage, declaration);
        return ruleCst06;
    }

    private IRule getCST04Rule(int id, FieldDescription anElement, DeclarationDescription declaration) {
        Cst04SyntaxControl ruleCst04 = new Cst04SyntaxControl(id, SyntacticControlCode.CST_04.getCode(), anElement, this.controlMessage, declaration);
        return ruleCst04;
    }

    private IRule getCSL11Rule(int id, FieldDescription anElement, DeclarationDescription declaration) {
        Csl11SyntaxControl ruleCsl11 = new Csl11SyntaxControl(id, SyntacticControlCode.CSL_11.getCode(), anElement, this.controlMessage, declaration);
        return ruleCsl11;
    }

    private IRule getCSL05Rule(int id, FieldDescription anElement, DeclarationDescription declaration) {
        String regexp = this.modelAccessor.getStandard().getAllowedCharactersRegex();
        Csl05SyntaxControl ruleCsl05 = new Csl05SyntaxControl(id, SyntacticControlCode.CSL_05.getCode(), anElement, anElement.getFullQualifiedId(), regexp, this.controlMessage, declaration);
        return ruleCsl05;
    }

    private IRule getCSL04Rule(int id, FieldDescription anElement, DeclarationDescription declaration) {
        Csl04SyntaxControl ruleCsl04 = new Csl04SyntaxControl(id, SyntacticControlCode.CSL_04.getCode(), anElement, this.controlMessage, declaration);
        return ruleCsl04;
    }

    private IRule getCSL03Rule(int id, FieldDescription anElement, DeclarationDescription declaration) {
        Csl03SyntaxControl ruleCsl03 = new Csl03SyntaxControl(id, SyntacticControlCode.CSL_03.getCode(), anElement, this.controlMessage, declaration);
        return ruleCsl03;
    }

    private IRule getCSL02Rule(int id, FieldDescription anElement, DeclarationDescription declaration) {
        NatureType nature = anElement.getDataType().getNature();
        Csl02SyntaxControl ruleCsl02 = new Csl02SyntaxControl(id, SyntacticControlCode.CSL_02.getCode(), anElement, anElement.getFullQualifiedId(), nature, this.controlMessage, declaration);
        return ruleCsl02;
    }

    private IRule getCSL01Rule(int id, FieldDescription anElement, DeclarationDescription declaration) {
        Csl01SyntaxControl ruleCsl01 = new Csl01SyntaxControl(id, SyntacticControlCode.CSL_01.getCode(), anElement, this.controlMessage, declaration);
        return ruleCsl01;
    }

    private IRule getCSL00Rule(int id, FieldDescription anElement, DeclarationDescription declaration) {
        String regexp = anElement.getDataType().getRegexp();
        Csl00SyntaxControl ruleCsl00 = null;
        if (regexp != null && !"".equals(regexp)) {
            ruleCsl00 = new Csl00SyntaxControl(id, SyntacticControlCode.CSL_00.getCode(), anElement, anElement.getFullQualifiedId(), regexp, this.controlMessage, declaration);
        }
        return ruleCsl00;
    }

    private IRule getCRERule(int id, FieldDescription anElement, DeclarationDescription declaration) {
        CRESyntaxControl ruleCRE = new CRESyntaxControl(id, SyntacticControlCode.CRE.getCode(), anElement, this.controlMessage, declaration, this.modelAccessor);
        return ruleCRE;
    }
}

