/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.reportfilter;

import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.IdQualifiedElementDescription;
import fr.cnav.saturne.api.model.access.MessageElementDescription;
import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.syntax.SyntacticControlCode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class PrimaryAnomaliesScopesProvider {
    private final Map<String, Set<IMessageBlock>> fieldToScopeMap = new HashMap<String, Set<IMessageBlock>>();
    private Stack<IMessageBlock> currentBlock = new Stack();

    public Map<String, Set<IMessageBlock>> getFieldToScopeMap() {
        return this.fieldToScopeMap;
    }

    private boolean isAnomalyAPrimaryOne(Anomaly anomaly) {
        return SyntacticControlCode.CST_06.getCode().equals(anomaly.getCode()) || SyntacticControlCode.CSL_03.getCode().equals(anomaly.getCode()) || SyntacticControlCode.CSL_02.getCode().equals(anomaly.getCode()) || SyntacticControlCode.CSL_04.getCode().equals(anomaly.getCode()) || "CV02".equals(anomaly.getCode());
    }

    public void signalAnomaly(Anomaly anomaly) {
        if (this.isAnomalyAPrimaryOne(anomaly)) {
            Set<IMessageBlock> messageBlockSet = this.fieldToScopeMap.get(anomaly.getFieldId());
            if (messageBlockSet == null) {
                messageBlockSet = new HashSet<IMessageBlock>();
                this.fieldToScopeMap.put(anomaly.getFieldId(), messageBlockSet);
            }
            if (this.currentBlock != null && !this.currentBlock.isEmpty() && !messageBlockSet.contains(this.currentBlock.peek())) {
                messageBlockSet.add(this.currentBlock.peek());
            }
        }
    }

    public void enterBlock(IMessageBlock messageBlock) {
        MessageElementDescription block = messageBlock.getStandardBlockDescription();
        IdQualifiedElementDescription eContainer = block.getParent();
        if (!(eContainer instanceof BlockDescription)) {
            this.currentBlock.push(messageBlock);
        } else {
            DeclarationDescription declaration = this.getDeclaration(block);
            if (declaration != null) {
                int blockUpperBound = declaration.getBlockUpperBound((BlockDescription)block);
                if (blockUpperBound > 1 || blockUpperBound == -1) {
                    this.currentBlock.push(messageBlock);
                }
            } else {
                int blockUpperBound = ((BlockDescription)block).getUpperBound();
                if (blockUpperBound > 1 || blockUpperBound == -1) {
                    this.currentBlock.push(messageBlock);
                }
            }
        }
    }

    private DeclarationDescription getDeclaration(MessageElementDescription block) {
        MessageElementDescription tempElement = block;
        while (tempElement instanceof MessageElementDescription && tempElement.getParent() != null) {
            if (tempElement.getParent() instanceof DeclarationDescription) {
                return (DeclarationDescription)block.getParent();
            }
            tempElement = tempElement.getParent();
        }
        return null;
    }

    public void exitBlock(IMessageBlock block) {
        if (this.currentBlock.peek() == block) {
            this.currentBlock.pop();
        }
    }
}

