/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.report.impl;

import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.report.model.Context;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.IReportSerializer;
import fr.cnav.saturne.validator.report.SerializationException;
import fr.cnav.saturne.validator.report.impl.GenericXMLReportSerializerHandler;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;

public class GenericXMLReportSerializer
implements IReportSerializer {
    public static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";

    @Override
    public void serialize(OutputStream outputStream, IReportLogger reportLogger, String namespacePrefix, String namespace, StandardAccessor modelAccessor) throws SerializationException {
        GenericXMLReportSerializerHandler xmlSerializer = this.getXmlSerializerHandler(reportLogger, namespacePrefix, namespace, modelAccessor.getStandard().getName(), modelAccessor.getNomenclatureVersion(), outputStream, DEFAULT_CHARACTER_ENCODING);
        xmlSerializer.beginSerialization();
        this.serialize(reportLogger.getReport().getRootContext(), xmlSerializer);
        xmlSerializer.endSerialization();
    }

    protected GenericXMLReportSerializerHandler getXmlSerializerHandler(IReportLogger reportLogger, String namespacePrefix, String namespace, String messageName, OutputStream outputStream, String encoding) throws SerializationException {
        return new GenericXMLReportSerializerHandler(reportLogger, namespacePrefix, namespace, messageName, outputStream, DEFAULT_CHARACTER_ENCODING);
    }

    protected GenericXMLReportSerializerHandler getXmlSerializerHandler(IReportLogger reportLogger, String namespacePrefix, String namespace, String messageName, Optional<String> nomenclatureVersion, OutputStream outputStream, String encoding) throws SerializationException {
        if (nomenclatureVersion.isPresent()) {
            return new GenericXMLReportSerializerHandler(reportLogger, namespacePrefix, namespace, messageName, nomenclatureVersion, outputStream, DEFAULT_CHARACTER_ENCODING);
        }
        return this.getXmlSerializerHandler(reportLogger, namespacePrefix, namespace, messageName, outputStream, DEFAULT_CHARACTER_ENCODING);
    }

    private void serialize(Context context, GenericXMLReportSerializerHandler xmlSerializer) throws SerializationException {
        xmlSerializer.pushContext(context);
        List<Context> contextChildren = context.getContextChildren();
        for (Context contextChild : contextChildren) {
            this.serialize(contextChild, xmlSerializer);
        }
        xmlSerializer.popContext();
    }
}

