/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.report.impl;

import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.report.model.Context;
import fr.cnav.saturne.report.model.ContextField;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.SerializationException;
import fr.cnav.saturne.validator.report.impl.AbstractReportSerializerHandler;
import fr.cnav.saturne.validator.report.impl.ReportContextDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GenericCSVReportSerializerHandler
extends AbstractReportSerializerHandler {
    protected static final String SEPARATOR = "_";
    protected static final String ANOMALIES_SUFFIX_LABEL = "anomalie";
    private static final int MIN_ASSESSEMENT_SIZE = 7;
    private static final String EOF = "\n";
    private static final String CONTEXT_RESULT_SUFFIX_LABEL = "bilan";
    private static final String VALIDITY_RESULT_LABEL = "OK";
    private static final String NO_VALIDITY_RESULT_LABEL = "KO";
    private static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    protected Writer writer;
    boolean isRootContextAssessment = true;
    private ReportContextDescriptor reportContextDescriptor;

    public GenericCSVReportSerializerHandler(IReportLogger reportLogger, OutputStream outputStream, String encoding) throws SerializationException {
        this.init(reportLogger);
        if (outputStream == null) {
            throw new IllegalArgumentException("The output stream should not be null. The serialization will not be realized.");
        }
        this.initializeWriter(outputStream, encoding == null ? DEFAULT_CHARACTER_ENCODING : encoding);
    }

    public GenericCSVReportSerializerHandler(IReportLogger reportLogger, Writer writer) throws SerializationException {
        this.init(reportLogger);
        this.writer = writer;
    }

    private void initializeWriter(OutputStream outputStream, String encoding) throws SerializationException {
        try {
            this.writer = new OutputStreamWriter(outputStream, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException(e);
        }
    }

    void init(IReportLogger reportLogger) {
        if (reportLogger == null) {
            throw new IllegalArgumentException("The report logger must not be null.");
        }
        this.reportContextDescriptor = reportLogger.geReportContextDescriptor();
    }

    @Override
    public void beginSerialization() throws SerializationException {
    }

    @Override
    public void endSerialization() throws SerializationException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new SerializationException("An exception has occurred while appending the footer of the converted file: " + e.getMessage(), e);
        }
    }

    private void serializeAnomalies(Context context) throws SerializationException {
        List<Anomaly> anomalies = context.getAnomalies();
        try {
            for (Anomaly anomaly : anomalies) {
                this.writer.write(EOF);
                this.writeAnomalyNode(context, anomaly);
            }
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }

    private void serializeAssessment(Context context) throws SerializationException {
        this.writeAssessmentNode(context);
    }

    private int getTotalAnomaliesNumber(Context context) {
        List<Context> contextChildren = context.getContextChildren();
        int anomaliesNumber = context.getAnomalies().size();
        for (Context contextChild : contextChildren) {
            anomaliesNumber += this.getTotalAnomaliesNumber(contextChild);
        }
        return anomaliesNumber;
    }

    private int getTotalNoBlockingAnomalies(Context context) {
        List<Context> contextChildren = context.getContextChildren();
        int anomaliesNumber = this.getNoBlockingAnomaliesNumber(context);
        for (Context contextChild : contextChildren) {
            anomaliesNumber += this.getTotalNoBlockingAnomalies(contextChild);
        }
        return anomaliesNumber;
    }

    private int getTotalBlockingAnomaliesNumber(Context context) {
        List<Context> contextChildren = context.getContextChildren();
        int anomaliesNumber = this.getBlockingAnomaliesNumber(context);
        for (Context contextChild : contextChildren) {
            anomaliesNumber += this.getTotalBlockingAnomaliesNumber(contextChild);
        }
        return anomaliesNumber;
    }

    private int getNoBlockingAnomaliesNumber(Context context) {
        List<Anomaly> anomalies = context.getAnomalies();
        int blockingAnomaliesNumber = 0;
        for (Anomaly anomaly : anomalies) {
            if (anomaly.isBlocking()) continue;
            ++blockingAnomaliesNumber;
        }
        return blockingAnomaliesNumber;
    }

    private int getBlockingAnomaliesNumber(Context context) {
        List<Anomaly> anomalies = context.getAnomalies();
        int blockingAnomaliesNumber = 0;
        for (Anomaly anomaly : anomalies) {
            if (!anomaly.isBlocking()) continue;
            ++blockingAnomaliesNumber;
        }
        return blockingAnomaliesNumber;
    }

    private Map<String, Integer> calculateSubContextNumber(Context context) {
        List<Context> contextChildren = context.getContextChildren();
        HashMap<String, Integer> contextSerialisationNameToContextNumber = new HashMap<String, Integer>();
        Set<String> directSubContextSerializationNames = this.reportContextDescriptor.getDirectSubContextSerializationNames(context);
        if (directSubContextSerializationNames == null) {
            throw new IllegalArgumentException("A context should have a serialization name.");
        }
        for (String directSubContextSerializationName : directSubContextSerializationNames) {
            contextSerialisationNameToContextNumber.put(directSubContextSerializationName, 0);
        }
        for (Context subcontext : contextChildren) {
            Integer subContextNumber = (Integer)contextSerialisationNameToContextNumber.get(subcontext.getName());
            subContextNumber = subContextNumber + 1;
            contextSerialisationNameToContextNumber.put(subcontext.getName(), subContextNumber);
        }
        return contextSerialisationNameToContextNumber;
    }

    @Override
    public void pushContext(Context context) throws SerializationException {
        try {
            this.serializeAssessment(context);
            this.serializeAnomalies(context);
            this.writer.write(EOF);
        }
        catch (IOException e) {
            throw new SerializationException("An exception has occurred while appending serializing the validation information." + e.getMessage(), e);
        }
    }

    @Override
    public void popContext() throws SerializationException {
    }

    private void writeAssessmentNode(Context context) throws SerializationException {
        try {
            this.writeStringInColumn(this.getAssessmentNodeId(context));
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        this.writeAssessmentContentNodes(context);
    }

    protected String getAssessmentNodeId(Context context) {
        return String.valueOf(context.getName()) + SEPARATOR + CONTEXT_RESULT_SUFFIX_LABEL;
    }

    private void writeAssessmentContentNodes(Context context) throws SerializationException {
        try {
            this.writer.write(59);
            boolean isSerializeValidationId = this.reportContextDescriptor.doAddValidationIdContext();
            Map<String, Integer> contextSerialisationNameToContextNumber = this.calculateSubContextNumber(context);
            ArrayList<String> assessmentValues = this.initAssesmentArrayValues(context, isSerializeValidationId, contextSerialisationNameToContextNumber.size());
            int i = 0;
            List<ContextField> contextFields = context.getContextFields();
            ContextField validationIdContextField = null;
            if (isSerializeValidationId && this.isRootContextAssessment) {
                validationIdContextField = this.getValidationContextFieldIndex(contextFields);
                if (validationIdContextField != null) {
                    assessmentValues.set(i, String.valueOf(validationIdContextField.getValue()));
                }
                ++i;
            }
            for (ContextField contextField : contextFields) {
                if ("validationID".equals(contextField.getReportSerializationName())) continue;
                assessmentValues.set(i, contextField.getValue());
                ++i;
            }
            if (context.isValid()) {
                assessmentValues.set(i, VALIDITY_RESULT_LABEL);
            } else {
                assessmentValues.set(i, NO_VALIDITY_RESULT_LABEL);
            }
            assessmentValues.set(++i, String.valueOf(context.getRank()));
            ++i;
            Set<Map.Entry<String, Integer>> entrySet = contextSerialisationNameToContextNumber.entrySet();
            for (Map.Entry<String, Integer> entry : entrySet) {
                assessmentValues.set(i, String.valueOf(String.valueOf(entry.getValue())));
                ++i;
            }
            if (context.doUseTotalAnomaliesCounter()) {
                assessmentValues.set(i, String.valueOf(this.getTotalAnomaliesNumber(context)));
                assessmentValues.set(++i, String.valueOf(this.getNoBlockingAnomaliesNumber(context)));
                assessmentValues.set(++i, String.valueOf(this.getTotalBlockingAnomaliesNumber(context)));
                ++i;
            } else {
                i += 3;
            }
            if (context.doUseAnomaliesCounter()) {
                assessmentValues.set(i, String.valueOf(this.getTotalNoBlockingAnomalies(context)));
                assessmentValues.set(++i, String.valueOf(this.getBlockingAnomaliesNumber(context)));
            }
            this.writeArray(assessmentValues);
            if (this.isRootContextAssessment) {
                this.isRootContextAssessment = false;
            }
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }

    private ArrayList<String> initAssesmentArrayValues(Context context, boolean isSerializeValidationId, int subContextNumber) {
        List<ContextField> contextFields = context.getContextFields();
        ContextField validationIdContextField = null;
        if (isSerializeValidationId) {
            validationIdContextField = this.getValidationContextFieldIndex(contextFields);
        }
        int assessmentSize = 7 + contextFields.size() + subContextNumber;
        if (isSerializeValidationId && validationIdContextField == null && this.isRootContextAssessment) {
            ++assessmentSize;
        }
        ArrayList<String> assessmentValues = new ArrayList<String>(assessmentSize);
        int j = 0;
        while (j < assessmentSize) {
            assessmentValues.add(null);
            ++j;
        }
        return assessmentValues;
    }

    private ContextField getValidationContextFieldIndex(List<ContextField> contextFields) {
        ContextField validationIdContextField = null;
        if (this.reportContextDescriptor.doAddValidationIdContext()) {
            for (ContextField contextField : contextFields) {
                if (!"validationID".equals(contextField.getReportSerializationName())) continue;
                return contextField;
            }
        }
        return validationIdContextField;
    }

    private void writeArray(ArrayList<String> values) throws SerializationException {
        try {
            if (!values.isEmpty()) {
                int lastIndex = values.size() - 1;
                int i = 0;
                while (i < lastIndex) {
                    this.writeStringInColumn(values.get(i));
                    this.writer.write(59);
                    ++i;
                }
                this.writeStringInColumn(values.get(lastIndex));
            }
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }

    private void writeAnomalyNode(Context context, Anomaly anomaly) throws SerializationException {
        try {
            this.writeStringInColumn(this.getAnomalyNodeId(context));
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        this.writeAnomalyDescriptionNode(anomaly);
        this.writeAnomalySectionNode(anomaly);
    }

    protected String getAnomalyNodeId(Context context) {
        return String.valueOf(context.getName()) + SEPARATOR + ANOMALIES_SUFFIX_LABEL;
    }

    private void writeAnomalyDescriptionNode(Anomaly anomaly) throws SerializationException {
        try {
            this.writer.write(59);
            this.writeStringInColumn(anomaly.getCode());
            this.writer.write(59);
            this.writeStringInColumn(anomaly.isBlocking() ? "bloquant" : "non bloquant");
            this.writer.write(59);
            this.writeStringInColumn(anomaly.getMessage());
            this.writer.write(59);
            this.writeStringInColumn(String.valueOf(anomaly.getFieldLocalizer().getLineNumber()));
            this.writer.write(59);
            this.writeStringInColumn(String.valueOf(anomaly.getNumber()));
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }

    private void writeAnomalySectionNode(Anomaly anomaly) throws SerializationException {
        try {
            this.writer.write(59);
            this.writeStringInColumn(anomaly.getFieldId());
            this.writer.write(59);
            this.writeStringInColumn(anomaly.getFieldLabel());
            this.writer.write(59);
            this.writeStringInColumn(anomaly.getFieldValue());
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }

    private void writeStringInColumn(String text) throws IOException {
        if (text != null) {
            this.writer.write("\"");
            this.writer.write(text);
            this.writer.write("\"");
        }
    }
}

