/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.functions;

import fr.cnav.saturne.IdQualifiedElement;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.api.model.access.StandardDescription;
import fr.cnav.saturne.options.Key;
import fr.cnav.saturne.options.OptionMap;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.IMessageSerializer;
import fr.cnav.saturne.validator.ISequenceProvider;
import fr.cnav.saturne.validator.ITreeAndDeclarationConsumer;
import fr.cnav.saturne.validator.IValidationOptions;
import fr.cnav.saturne.validator.SaturneValidatorException;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.api.AbstractKBDescriptor;
import fr.cnav.saturne.validator.api.IMessageProcessor;
import fr.cnav.saturne.validator.conversion.ConversionSerializationException;
import fr.cnav.saturne.validator.conversion.OriginalValueOptionValue;
import fr.cnav.saturne.validator.conversion.TreeBuilder;
import fr.cnav.saturne.validator.conversion.csv.CSVSequenceReader;
import fr.cnav.saturne.validator.conversion.csv.CSVSerializer;
import fr.cnav.saturne.validator.conversion.json.JsonSequenceReader;
import fr.cnav.saturne.validator.conversion.json.JsonStreamSerializer;
import fr.cnav.saturne.validator.conversion.keyvalue.SequentialReader;
import fr.cnav.saturne.validator.conversion.keyvalue.SequentialSerializer;
import fr.cnav.saturne.validator.conversion.xml.XMLSerializer;
import fr.cnav.saturne.validator.conversion.xml.XMLUtil;
import fr.cnav.saturne.validator.functions.CSVConfiguration;
import fr.cnav.saturne.validator.message.MessageProvider;
import fr.cnav.saturne.validator.message.MessageRecuperator;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.positional.FormatSpecification;
import fr.cnav.saturne.validator.positional.conversion.PositionalFixSequenceReader;
import fr.cnav.saturne.validator.positional.conversion.PositionalFixSerializer;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.IReportSerializer;
import fr.cnav.saturne.validator.report.SerializationException;
import fr.cnav.saturne.validator.report.TooManyAnomaliesException;
import fr.cnav.saturne.validator.report.impl.GenericXMLReportSerializer;
import fr.cnav.saturne.validator.xml.XMLReader;
import fr.cnav.saturne.validator.xml.XMLReaderWithDecl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class MessageProcessor
implements IMessageProcessor {
    private static final String KBDESCRIPTOR_CANNOT_BE_NULL = "The parameter KbDescriptor cannot be null";
    private static final String SEQUENCE_PROVIDER_CANNOT_BE_NULL = "The parameter sequenceProvider cannot be null";
    private AbstractKBDescriptor kbDescriptor;
    private ControlMessages controlMessage;
    private StandardAccessor modelAccessor;

    public MessageProcessor(AbstractKBDescriptor theKbDescriptor) {
        if (theKbDescriptor == null) {
            throw new IllegalArgumentException(KBDESCRIPTOR_CANNOT_BE_NULL);
        }
        this.kbDescriptor = theKbDescriptor;
        this.controlMessage = new ControlMessages(this.kbDescriptor.getResourceBundle());
        this.modelAccessor = this.kbDescriptor.getStandardAccessor();
    }

    @Override
    public IMessageBlock readKeyValueMessage(InputStream input, IReportLogger logger) throws TreeProcessingException {
        if (input == null) {
            throw new IllegalArgumentException("The parameter inputStream of the conversion method can't be null");
        }
        if (logger == null) {
            throw new IllegalArgumentException("The parameter reportLogger of the conversion method can't be null");
        }
        StandardDescription standardDescription = this.modelAccessor.getStandardDescription();
        SequentialReader reader = new SequentialReader(standardDescription, this.kbDescriptor.getOptions(), this.controlMessage, this.modelAccessor, input, Charset.forName(standardDescription.getMessagesEncoding()));
        return this.readMessage(reader, logger);
    }

    @Override
    public IMessageBlock readXMLMessage(InputStream input, IReportLogger logger, boolean xmlNoPrefix) throws TreeProcessingException {
        if (input == null) {
            throw new IllegalArgumentException("The parameter inputStream of the conversion method can't be null");
        }
        if (logger == null) {
            throw new IllegalArgumentException("The parameter reportLogger of the conversion method can't be null");
        }
        Map<String, String> xmlTag2QualifiedId = this.initializeMap();
        XMLReader xmlReader = new XMLReader(logger, this.kbDescriptor.getOptions(), this.modelAccessor, xmlTag2QualifiedId, this.controlMessage, true, xmlNoPrefix);
        MessageRecuperator messageConstructor = new MessageRecuperator();
        xmlReader.addConsumer(messageConstructor);
        xmlReader.addConsumer(logger);
        try {
            xmlReader.read(input);
        }
        catch (IOException e) {
            throw new TreeProcessingException(e);
        }
        return messageConstructor.getRootMessageBlock();
    }

    @Override
    public IMessageBlock readXMLMessage(InputStream input, IReportLogger logger) throws TreeProcessingException {
        return this.readXMLMessage(input, logger, true);
    }

    @Override
    public IMessageBlock readCSVMessage(InputStream input, CSVConfiguration csvFormat, IReportLogger logger) throws TreeProcessingException {
        if (input == null) {
            throw new IllegalArgumentException("The parameter inputStream of the conversion method can't be null");
        }
        if (logger == null) {
            throw new IllegalArgumentException("The parameter reportLogger of the conversion method can't be null");
        }
        StandardDescription standard = this.modelAccessor.getStandardDescription();
        CSVSequenceReader reader = null;
        try {
            reader = new CSVSequenceReader(standard, this.kbDescriptor.getOptions(), this.controlMessage, this.modelAccessor, input, csvFormat);
        }
        catch (SaturneValidatorException e) {
            throw new TreeProcessingException(e);
        }
        return this.readMessage(reader, logger);
    }

    @Override
    public IMessageBlock readPosFixMessage(InputStream input, FormatSpecification pfxFormat, IReportLogger logger) throws TreeProcessingException {
        if (logger == null) {
            throw new IllegalArgumentException("The parameter reportLogger of the conversion method can't be null");
        }
        if (input == null) {
            throw new IllegalArgumentException("The parameter inputStream of the conversion method can't be null");
        }
        if (pfxFormat == null) {
            throw new IllegalArgumentException("The parameter positionalFix format cannot be null");
        }
        Standard standard = this.modelAccessor.getStandard();
        PositionalFixSequenceReader reader = new PositionalFixSequenceReader(pfxFormat, this.kbDescriptor.getOptions(), this.controlMessage, this.modelAccessor, input, Charset.forName(standard.getMessagesEncoding()));
        return this.readMessage(reader, logger);
    }

    @Override
    public IMessageBlock readMessage(ISequenceProvider sequenceProvider, IReportLogger logger) throws TreeProcessingException {
        if (logger == null) {
            throw new IllegalArgumentException("The parameter reportLogger of the conversion method can't be null");
        }
        if (sequenceProvider == null) {
            throw new IllegalArgumentException(SEQUENCE_PROVIDER_CANNOT_BE_NULL);
        }
        MessageRecuperator messageRecuperator = null;
        try {
            TreeBuilder treeBuilder = new TreeBuilder(this.modelAccessor, logger, this.controlMessage, sequenceProvider);
            messageRecuperator = new MessageRecuperator();
            treeBuilder.addConsumer(messageRecuperator);
            treeBuilder.addConsumer(logger);
            treeBuilder.convert();
        }
        catch (SaturneValidatorException e) {
            throw new TreeProcessingException(e);
        }
        catch (TooManyAnomaliesException e) {
            throw new TreeProcessingException(e);
        }
        return messageRecuperator.getRootMessageBlock();
    }

    @Override
    public void writeKeyValueMessage(IMessageBlock messageRoot, OutputStream keyValueOutput) throws TreeProcessingException {
        if (messageRoot == null) {
            throw new IllegalArgumentException("The parameter outputStream cannot be null");
        }
        if (keyValueOutput == null) {
            throw new IllegalArgumentException("The parameter message of the conversion method can't be null");
        }
        try {
            MessageProvider messageProvider = new MessageProvider(this.modelAccessor);
            SequentialSerializer keyValueSerializer = new SequentialSerializer(this.modelAccessor.getStandard(), keyValueOutput);
            messageProvider.addConsumer(keyValueSerializer);
            messageProvider.notifiesMessage(messageRoot);
        }
        catch (ConversionSerializationException e) {
            throw new TreeProcessingException(e);
        }
    }

    @Override
    public void writeXMLMessage(IMessageBlock messageRoot, OutputStream xmlOutput, OptionMap options) throws TreeProcessingException {
        if (messageRoot == null) {
            throw new IllegalArgumentException("The parameter outputStream cannot be null");
        }
        if (xmlOutput == null) {
            throw new IllegalArgumentException("The parameter message of the conversion method can't be null");
        }
        StandardDescription standard = this.modelAccessor.getStandardDescription();
        Boolean xmlNoPrefix = false;
        OriginalValueOptionValue originalValue = IValidationOptions.DEFAULT_OUTPUT_ORIGINAL_VALUES;
        Boolean showOriginalLineNumber = true;
        if (options != null) {
            xmlNoPrefix = (Boolean)options.getOption(new Key("fr.cnav.saturne.xmlNoPrefix"));
            if (xmlNoPrefix == null) {
                xmlNoPrefix = true;
            }
            if ((originalValue = (OriginalValueOptionValue)((Object)options.getOption(new Key("fr.cnav.norme.val.originalValue")))) == null) {
                originalValue = IValidationOptions.DEFAULT_OUTPUT_ORIGINAL_VALUES;
            }
            if ((showOriginalLineNumber = (Boolean)options.getOption(new Key("line.number.location"))) == null) {
                showOriginalLineNumber = true;
            }
        }
        try {
            MessageProvider messageProvider = new MessageProvider(this.modelAccessor);
            XMLSerializer xmlSerializer = new XMLSerializer(standard, xmlOutput, standard.getMessagesEncoding(), originalValue, showOriginalLineNumber, xmlNoPrefix);
            messageProvider.addConsumer(xmlSerializer);
            messageProvider.notifiesMessage(messageRoot);
        }
        catch (ConversionSerializationException e) {
            throw new TreeProcessingException(e);
        }
    }

    @Override
    public void writeXMLMessage(IMessageBlock messageRoot, OutputStream xmlOutput, boolean xmlNoPrefix) throws TreeProcessingException {
        OptionMap options = new OptionMap();
        options.setOption(new Key("fr.cnav.saturne.xmlNoPrefix"), (Object)xmlNoPrefix);
        this.writeXMLMessage(messageRoot, xmlOutput, options);
    }

    @Override
    public void writeXMLMessage(IMessageBlock messageRoot, OutputStream xmlOutput) throws TreeProcessingException {
        OptionMap options = new OptionMap();
        options.setOption(new Key("fr.cnav.saturne.xmlNoPrefix"), (Object)false);
        this.writeXMLMessage(messageRoot, xmlOutput, options);
    }

    @Override
    public void writeCSVMessage(IMessageBlock messageRoot, CSVConfiguration csvFormat, OutputStream outputCSV) throws TreeProcessingException {
        if (messageRoot == null) {
            throw new IllegalArgumentException("The parameter outputStream cannot be null");
        }
        if (outputCSV == null) {
            throw new IllegalArgumentException("The parameter message of the conversion method can't be null");
        }
        Standard standard = this.modelAccessor.getStandard();
        try {
            MessageProvider messageProvider = new MessageProvider(this.modelAccessor);
            CSVSerializer csvSerializer = null;
            csvSerializer = csvFormat == null ? new CSVSerializer(standard, outputCSV, standard.getMessagesEncoding(), '\"', ';') : new CSVSerializer(standard, outputCSV, standard.getMessagesEncoding(), csvFormat.getFieldDelimiter(), csvFormat.getSeparator());
            messageProvider.addConsumer(csvSerializer);
            messageProvider.notifiesMessage(messageRoot);
        }
        catch (ConversionSerializationException e) {
            throw new TreeProcessingException(e);
        }
    }

    @Override
    public void writePosFixMessage(IMessageBlock messageRoot, FormatSpecification pfxFormat, OutputStream outputPFX) throws TreeProcessingException {
        if (messageRoot == null) {
            throw new IllegalArgumentException("The parameter outputStream cannot be null");
        }
        if (outputPFX == null) {
            throw new IllegalArgumentException("The parameter message of the conversion method can't be null");
        }
        if (pfxFormat == null) {
            throw new IllegalArgumentException("The parameter positionalFix format cannot be null");
        }
        Standard standard = this.modelAccessor.getStandard();
        try {
            MessageProvider messageProvider = new MessageProvider(this.modelAccessor);
            PositionalFixSerializer pfxSerializer = new PositionalFixSerializer(this.modelAccessor.getStandard(), pfxFormat, outputPFX, standard.getMessagesEncoding());
            messageProvider.addConsumer(pfxSerializer);
            messageProvider.notifiesMessage(messageRoot);
        }
        catch (ConversionSerializationException e) {
            throw new TreeProcessingException(e);
        }
    }

    @Override
    public void writeMessage(IMessageBlock messageRoot, IMessageSerializer serializer, OutputStream output) throws TreeProcessingException {
        if (messageRoot == null) {
            throw new IllegalArgumentException("The parameter outputStream cannot be null");
        }
        if (output == null) {
            throw new IllegalArgumentException("The parameter message of the conversion method can't be null");
        }
        try {
            serializer.serialize(messageRoot, output);
        }
        catch (IOException e) {
            throw new TreeProcessingException(e);
        }
    }

    @Override
    public void writeXMLReport(IReportLogger report, OutputStream reportOutput) throws TreeProcessingException {
        if (reportOutput == null) {
            throw new IllegalArgumentException("The parameter reportOutput cannot be null");
        }
        if (report == null) {
            throw new IllegalArgumentException("The parameter reportLogger of the conversion method can't be null");
        }
        GenericXMLReportSerializer serializer = new GenericXMLReportSerializer();
        StandardDescription standard = this.modelAccessor.getStandardDescription();
        try {
            serializer.serialize(reportOutput, report, standard.getNamespacePrefix(), standard.getNameSpace(), this.modelAccessor);
        }
        catch (SerializationException e) {
            throw new TreeProcessingException(e);
        }
    }

    @Override
    public void writeReport(IReportLogger report, IReportSerializer theSerializer, OutputStream reportOutput) throws TreeProcessingException {
        IReportSerializer serializer = theSerializer;
        if (reportOutput == null) {
            throw new IllegalArgumentException("The parameter reportOutput cannot be null");
        }
        if (report == null) {
            throw new IllegalArgumentException("The parameter reportLogger of the conversion method can't be null");
        }
        if (serializer == null) {
            serializer = new GenericXMLReportSerializer();
        }
        StandardDescription standard = this.modelAccessor.getStandardDescription();
        try {
            serializer.serialize(reportOutput, report, standard.getNamespacePrefix(), standard.getNameSpace(), this.modelAccessor);
        }
        catch (SerializationException e) {
            throw new TreeProcessingException(e);
        }
    }

    @Override
    public void processMessage(IMessageBlock messageRoot, IReportLogger logger, ITreeAndDeclarationConsumer ... consummers) throws TreeProcessingException {
        if (messageRoot == null) {
            throw new IllegalArgumentException("The parameter outputStream cannot be null");
        }
        if (logger == null) {
            throw new IllegalArgumentException("The parameter reportLogger of the conversion method can't be null");
        }
        MessageProvider messageProvider = new MessageProvider(this.modelAccessor);
        ITreeAndDeclarationConsumer[] iTreeAndDeclarationConsumerArray = consummers;
        int n = consummers.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeAndDeclarationConsumer consumer = iTreeAndDeclarationConsumerArray[n2];
            if (consumer != null) {
                messageProvider.addConsumer(consumer);
            }
            ++n2;
        }
        messageProvider.addConsumer(logger);
        messageProvider.notifiesMessage(messageRoot);
    }

    @Override
    public void processMessage(InputStream input, ISequenceProvider sequenceProvider, IReportLogger logger, ITreeAndDeclarationConsumer ... consummers) throws TreeProcessingException {
        if (input == null) {
            throw new IllegalArgumentException("The parameter inputStream of the conversion method can't be null");
        }
        if (logger == null) {
            throw new IllegalArgumentException("The parameter reportLogger of the conversion method can't be null");
        }
        if (sequenceProvider == null) {
            throw new IllegalArgumentException(SEQUENCE_PROVIDER_CANNOT_BE_NULL);
        }
        TreeBuilder treeBuilder = new TreeBuilder(this.modelAccessor, logger, this.controlMessage, sequenceProvider);
        ITreeAndDeclarationConsumer[] iTreeAndDeclarationConsumerArray = consummers;
        int n = consummers.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeAndDeclarationConsumer consumer = iTreeAndDeclarationConsumerArray[n2];
            if (consumer != null) {
                treeBuilder.addConsumer(consumer);
            }
            ++n2;
        }
        try {
            treeBuilder.convert();
        }
        catch (TooManyAnomaliesException e) {
            throw new TreeProcessingException(e);
        }
        catch (SaturneValidatorException e) {
            throw new TreeProcessingException(e);
        }
    }

    @Override
    public IMessageBlock processAndGetMessage(InputStream input, ISequenceProvider sequenceProvider, IReportLogger logger, ITreeAndDeclarationConsumer ... theConsummers) throws TreeProcessingException {
        MessageRecuperator messageRecuperator = new MessageRecuperator();
        int lengthNewConsumers = 1;
        if (theConsummers != null) {
            lengthNewConsumers += theConsummers.length;
        }
        ITreeAndDeclarationConsumer[] consumers = new ITreeAndDeclarationConsumer[lengthNewConsumers + 1];
        consumers[0] = messageRecuperator;
        if (theConsummers != null) {
            System.arraycopy(theConsummers, 0, consumers, 1, theConsummers.length);
        }
        this.processMessage(input, sequenceProvider, logger, consumers);
        return messageRecuperator.getRootMessageBlock();
    }

    @Override
    public void processXMLMessage(InputStream inputXML, boolean xmlNoPrefix, IReportLogger reportLogger, ITreeAndDeclarationConsumer ... consummers) throws TreeProcessingException {
        if (inputXML == null) {
            throw new IllegalArgumentException("The parameter inputStream of the conversion method can't be null");
        }
        if (reportLogger == null) {
            throw new IllegalArgumentException("The parameter reportLogger of the conversion method can't be null");
        }
        Map<String, String> xmlTag2QualifiedId = this.initializeMap();
        XMLReaderWithDecl xmlReader = new XMLReaderWithDecl(reportLogger, this.kbDescriptor.getOptions(), this.modelAccessor, xmlTag2QualifiedId, this.controlMessage, true, xmlNoPrefix);
        ITreeAndDeclarationConsumer[] iTreeAndDeclarationConsumerArray = consummers;
        int n = consummers.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeAndDeclarationConsumer consumer = iTreeAndDeclarationConsumerArray[n2];
            if (consumer != null) {
                xmlReader.addConsumer(consumer);
            }
            ++n2;
        }
        try {
            xmlReader.read(inputXML);
        }
        catch (IOException e) {
            throw new TreeProcessingException(e);
        }
    }

    @Override
    public void processXMLMessage(InputStream inputXML, IReportLogger reportLogger, ITreeAndDeclarationConsumer ... consummers) throws TreeProcessingException {
        this.processXMLMessage(inputXML, true, reportLogger, consummers);
    }

    @Override
    public IMessageBlock processXMLMessageAndGetMessage(InputStream inputXML, boolean xmlNoPrefix, IReportLogger reportLogger, ITreeAndDeclarationConsumer ... theConsummers) throws TreeProcessingException {
        MessageRecuperator messageRecuperator = new MessageRecuperator();
        int lengthNewConsumers = 1;
        if (theConsummers != null) {
            lengthNewConsumers += theConsummers.length;
        }
        ITreeAndDeclarationConsumer[] consumers = new ITreeAndDeclarationConsumer[lengthNewConsumers + 1];
        consumers[0] = messageRecuperator;
        if (theConsummers != null) {
            System.arraycopy(theConsummers, 0, consumers, 1, theConsummers.length);
        }
        this.processXMLMessage(inputXML, xmlNoPrefix, reportLogger, consumers);
        return messageRecuperator.getRootMessageBlock();
    }

    @Override
    public IMessageBlock processXMLMessageAndGetMessage(InputStream inputXML, IReportLogger reportLogger, ITreeAndDeclarationConsumer ... consummers) throws TreeProcessingException {
        return this.processXMLMessageAndGetMessage(inputXML, true, reportLogger, consummers);
    }

    @Override
    public void processCSVMessage(InputStream inputCSV, CSVConfiguration csvFormat, IReportLogger reportLogger, ITreeAndDeclarationConsumer ... consummers) throws TreeProcessingException {
        if (inputCSV == null) {
            throw new IllegalArgumentException("The parameter inputStream of the conversion method can't be null");
        }
        if (reportLogger == null) {
            throw new IllegalArgumentException("The parameter reportLogger of the conversion method can't be null");
        }
        try {
            StandardDescription standardDescription = this.modelAccessor.getStandardDescription();
            CSVSequenceReader csvSequenceReader = new CSVSequenceReader(standardDescription, this.kbDescriptor.getOptions(), this.controlMessage, this.modelAccessor, inputCSV, csvFormat);
            this.processMessage(inputCSV, csvSequenceReader, reportLogger, consummers);
        }
        catch (SaturneValidatorException e) {
            throw new TreeProcessingException(e);
        }
    }

    @Override
    public IMessageBlock processCSVMessageAndGetMessage(InputStream inputCSV, CSVConfiguration csvFormat, IReportLogger reportLogger, ITreeAndDeclarationConsumer ... theConsummers) throws TreeProcessingException {
        MessageRecuperator messageRecuperator = new MessageRecuperator();
        LinkedList<ITreeAndDeclarationConsumer> tempList = new LinkedList<ITreeAndDeclarationConsumer>(Arrays.asList(theConsummers));
        tempList.add(0, messageRecuperator);
        ITreeAndDeclarationConsumer[] consummers = tempList.toArray(new ITreeAndDeclarationConsumer[tempList.size()]);
        this.processCSVMessage(inputCSV, csvFormat, reportLogger, consummers);
        return messageRecuperator.getRootMessageBlock();
    }

    @Override
    public void processKeyValueMessage(InputStream inputKeyValue, IReportLogger logger, ITreeAndDeclarationConsumer ... consummers) throws TreeProcessingException {
        if (inputKeyValue == null) {
            throw new IllegalArgumentException("The parameter inputStream of the conversion method can't be null");
        }
        if (logger == null) {
            throw new IllegalArgumentException("The parameter reportLogger of the conversion method can't be null");
        }
        StandardDescription standardDescription = this.modelAccessor.getStandardDescription();
        SequentialReader sequentialReader = new SequentialReader(standardDescription, this.kbDescriptor.getOptions(), this.controlMessage, this.modelAccessor, inputKeyValue, Charset.forName(standardDescription.getMessagesEncoding()));
        this.processMessage(inputKeyValue, sequentialReader, logger, consummers);
    }

    @Override
    public IMessageBlock processKeyValueMessageAndGetMessage(InputStream inputKeyValue, IReportLogger logger, ITreeAndDeclarationConsumer ... theConsummers) throws TreeProcessingException {
        MessageRecuperator messageRecuperator = new MessageRecuperator();
        LinkedList<ITreeAndDeclarationConsumer> tempList = new LinkedList<ITreeAndDeclarationConsumer>(Arrays.asList(theConsummers));
        tempList.add(0, messageRecuperator);
        ITreeAndDeclarationConsumer[] consummers = tempList.toArray(new ITreeAndDeclarationConsumer[tempList.size()]);
        this.processKeyValueMessage(inputKeyValue, logger, consummers);
        return messageRecuperator.getRootMessageBlock();
    }

    @Override
    public void processPosFixMessage(InputStream inputPFX, FormatSpecification pfxFormat, IReportLogger reportLogger, ITreeAndDeclarationConsumer ... consummers) throws TreeProcessingException {
        if (inputPFX == null) {
            throw new IllegalArgumentException("The parameter inputStream of the conversion method can't be null");
        }
        if (pfxFormat == null) {
            throw new IllegalArgumentException("The parameter positionalFix format cannot be null");
        }
        Standard standard = this.modelAccessor.getStandard();
        PositionalFixSequenceReader pfxReader = new PositionalFixSequenceReader(pfxFormat, this.kbDescriptor.getOptions(), this.controlMessage, this.modelAccessor, inputPFX, Charset.forName(standard.getMessagesEncoding()));
        this.processMessage(inputPFX, pfxReader, reportLogger, consummers);
    }

    @Override
    public IMessageBlock processPosFixMessageAndGetMessage(InputStream inputPFX, FormatSpecification pfxFormat, IReportLogger reportLogger, ITreeAndDeclarationConsumer ... consummers) throws TreeProcessingException {
        if (inputPFX == null) {
            throw new IllegalArgumentException("The parameter inputStream of the conversion method can't be null");
        }
        if (pfxFormat == null) {
            throw new IllegalArgumentException("The parameter positionalFix format cannot be null");
        }
        Standard standard = this.modelAccessor.getStandard();
        PositionalFixSequenceReader pfxReader = new PositionalFixSequenceReader(pfxFormat, this.kbDescriptor.getOptions(), this.controlMessage, this.modelAccessor, inputPFX, Charset.forName(standard.getMessagesEncoding()));
        return this.processAndGetMessage(inputPFX, pfxReader, reportLogger, consummers);
    }

    private Map<String, String> initializeMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Standard standard = this.modelAccessor.getStandard();
        TreeIterator iterator = standard.getMessage().eAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof IdQualifiedElement)) continue;
            String id = ((IdQualifiedElement)eObject).getFullQualifiedId();
            map.put(XMLUtil.getTagNameFromQualifiedId(id), id);
        }
        map.put(XMLUtil.getTagNameFromQualifiedId(standard.getMessage().getFullQualifiedId()), standard.getMessage().getFullQualifiedId());
        return map;
    }

    public ControlMessages getControlMessage() {
        return this.controlMessage;
    }

    @Override
    public void processJsonMessage(InputStream inputJson, IReportLogger reportLogger, ITreeAndDeclarationConsumer ... consummers) throws TreeProcessingException {
        if (inputJson == null) {
            throw new IllegalArgumentException("The parameter inputStream of the conversion method can't be null");
        }
        if (reportLogger == null) {
            throw new IllegalArgumentException("The parameter reportLogger of the conversion method can't be null");
        }
        try {
            StandardDescription standardDescription = this.modelAccessor.getStandardDescription();
            JsonSequenceReader jsonSequenceReader = new JsonSequenceReader(this.kbDescriptor.getOptions(), this.controlMessage, this.modelAccessor, inputJson, Charset.forName(standardDescription.getMessagesEncoding()));
            this.processMessage(inputJson, jsonSequenceReader, reportLogger, consummers);
        }
        catch (SaturneValidatorException e) {
            throw new TreeProcessingException(e);
        }
    }

    @Override
    public IMessageBlock processJsonMessageAndGetMessage(InputStream inputJson, IReportLogger reportLogger, ITreeAndDeclarationConsumer ... theConsummers) throws TreeProcessingException {
        MessageRecuperator messageRecuperator = new MessageRecuperator();
        LinkedList<ITreeAndDeclarationConsumer> tempList = new LinkedList<ITreeAndDeclarationConsumer>(Arrays.asList(theConsummers));
        tempList.add(0, messageRecuperator);
        ITreeAndDeclarationConsumer[] consummers = tempList.toArray(new ITreeAndDeclarationConsumer[tempList.size()]);
        this.processJsonMessage(inputJson, reportLogger, consummers);
        return messageRecuperator.getRootMessageBlock();
    }

    @Override
    public IMessageBlock readJSONMessage(InputStream input, IReportLogger logger) throws TreeProcessingException {
        if (input == null) {
            throw new IllegalArgumentException("The parameter inputStream of the conversion method can't be null");
        }
        if (logger == null) {
            throw new IllegalArgumentException("The parameter reportLogger of the conversion method can't be null");
        }
        StandardDescription standard = this.modelAccessor.getStandardDescription();
        JsonSequenceReader reader = null;
        try {
            reader = new JsonSequenceReader(this.kbDescriptor.getOptions(), this.controlMessage, this.modelAccessor, input, Charset.forName(standard.getMessagesEncoding()));
        }
        catch (SaturneValidatorException e) {
            throw new TreeProcessingException(e);
        }
        return this.readMessage(reader, logger);
    }

    @Override
    public void writeJsonMessage(IMessageBlock messageRoot, OutputStream output) throws TreeProcessingException {
        if (messageRoot == null) {
            throw new IllegalArgumentException("The parameter outputStream cannot be null");
        }
        if (output == null) {
            throw new IllegalArgumentException("The parameter message of the conversion method can't be null");
        }
        StandardDescription standard = this.modelAccessor.getStandardDescription();
        try {
            MessageProvider messageProvider = new MessageProvider(this.modelAccessor);
            JsonStreamSerializer jsonSerializer = new JsonStreamSerializer(standard, output, Charset.forName(standard.getMessagesEncoding()));
            messageProvider.addConsumer(jsonSerializer);
            messageProvider.notifiesMessage(messageRoot);
        }
        catch (UnsupportedEncodingException e) {
            throw new TreeProcessingException(e);
        }
    }
}

