/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.conversion.keyvalue;

import fr.cnav.saturne.Standard;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.conversion.ConversionSerializationException;
import fr.cnav.saturne.validator.conversion.keyvalue.SequentialSerializer;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.message.api.IMessageFieldAlphanum;
import fr.cnav.saturne.validator.message.api.IMessageFieldDate;
import fr.cnav.saturne.validator.message.api.IMessageFieldNum;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class SequentialStreamSerializer
extends SequentialSerializer {
    public SequentialStreamSerializer(Standard theStandard, OutputStream outputStream) throws ConversionSerializationException {
        super(theStandard, outputStream);
    }

    public SequentialStreamSerializer(Standard theStandard, Writer parent) throws ConversionSerializationException {
        super(theStandard, parent);
    }

    @Override
    public void startTree() throws TreeProcessingException {
        super.startTree();
    }

    @Override
    public void endTree() throws TreeProcessingException {
        super.endTree();
    }

    @Override
    public void enterBlock(IMessageBlock block) throws TreeProcessingException {
    }

    public static String formatLine(String fieldFQId, String value) {
        return String.valueOf(fieldFQId) + "," + "'" + value + "'" + "\n";
    }

    @Override
    public void exitBlock(IMessageBlock block) throws TreeProcessingException {
        super.exitBlock(block);
    }

    @Override
    public void signalAlphanumField(IMessageFieldAlphanum field) throws TreeProcessingException {
        this.writeField(field);
    }

    @Override
    public void signalNumericField(IMessageFieldNum field) throws TreeProcessingException {
        this.writeField(field);
    }

    @Override
    public void signalDateField(IMessageFieldDate field) throws TreeProcessingException {
        this.writeField(field);
    }

    @Override
    public void signalDeclaration(IMessageBlock block, DeclarationDescription declaration) throws TreeProcessingException {
    }

    private void writeField(IMessageField<?> field) throws TreeProcessingException {
        try {
            this.writer.write(SequentialStreamSerializer.formatLine(field.getStandardFieldDescription().getFullQualifiedId(), field.getOriginalValueAsString()));
        }
        catch (IOException e) {
            throw new TreeProcessingException(e);
        }
    }
}

