/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.conversion.keyvalue;

import fr.cnav.saturne.Standard;
import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.validator.ITreeAndDeclarationConsumer;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.conversion.ConversionSerializationException;
import fr.cnav.saturne.validator.impl.ValidatorEncodingHandler;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.message.api.IMessageFieldAlphanum;
import fr.cnav.saturne.validator.message.api.IMessageFieldDate;
import fr.cnav.saturne.validator.message.api.IMessageFieldNum;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;

public class SequentialSerializer
implements ITreeAndDeclarationConsumer {
    protected final Writer writer;

    public SequentialSerializer(Standard theStandard, OutputStream outputStream) throws ConversionSerializationException {
        if (theStandard == null) {
            throw new IllegalArgumentException("The standard should not be null. The serialization will not be realized.");
        }
        if (theStandard.getNamespacePrefix() == null) {
            throw new IllegalArgumentException("The standard namespace prefix should not be null. The serialization will not be realized.");
        }
        if (theStandard.getNameSpace() == null) {
            throw new IllegalArgumentException("The standard namespace should not be null. The serialization will not be realized.");
        }
        ValidatorEncodingHandler validatorEncodingHandler = new ValidatorEncodingHandler();
        if (outputStream == null) {
            throw new IllegalArgumentException("The output stream should not be null. The serialization will not be realized.");
        }
        Charset usedEncoding = validatorEncodingHandler.getEncodingToUse(theStandard);
        this.writer = new OutputStreamWriter(outputStream, usedEncoding);
    }

    public SequentialSerializer(Standard theStandard, Writer parent) throws ConversionSerializationException {
        if (theStandard == null) {
            throw new IllegalArgumentException("The standard should not be null. The serialization will not be realized.");
        }
        if (theStandard.getNamespacePrefix() == null) {
            throw new IllegalArgumentException("The standard namespace prefix should not be null. The serialization will not be realized.");
        }
        if (theStandard.getNameSpace() == null) {
            throw new IllegalArgumentException("The standard namespace should not be null. The serialization will not be realized.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("The writer should not be null. The serialization will not be realized.");
        }
        this.writer = parent;
    }

    @Override
    public void startTree() throws TreeProcessingException {
    }

    @Override
    public void endTree() throws TreeProcessingException {
        try {
            this.writer.flush();
        }
        catch (IOException exception) {
            throw new TreeProcessingException("An exception has occured while appending the footer of the converted file: " + exception.getMessage(), exception);
        }
    }

    @Override
    public void enterBlock(IMessageBlock block) throws TreeProcessingException {
        if (block.getStandardBlockDescription() instanceof BlockDescription) {
            List<IMessageField<?>> fields = block.getFields();
            for (IMessageField<?> messageField : fields) {
                try {
                    this.writer.write(SequentialSerializer.formatLine(messageField.getStandardFieldDescription().getFullQualifiedId(), messageField.getOriginalValueAsString()));
                }
                catch (IOException e) {
                    throw new TreeProcessingException(e);
                }
            }
        }
    }

    public static String formatLine(String fieldFQId, String value) {
        return String.valueOf(fieldFQId) + "," + "'" + value + "'" + "\n";
    }

    @Override
    public void exitBlock(IMessageBlock block) throws TreeProcessingException {
    }

    @Override
    public void signalAlphanumField(IMessageFieldAlphanum field) throws TreeProcessingException {
    }

    @Override
    public void signalNumericField(IMessageFieldNum field) throws TreeProcessingException {
    }

    @Override
    public void signalDateField(IMessageFieldDate field) throws TreeProcessingException {
    }

    @Override
    public void signalDeclaration(IMessageBlock block, DeclarationDescription declaration) throws TreeProcessingException {
    }
}

