/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.utils;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.FieldRefinement;
import fr.cnav.saturne.GenericRule;
import fr.cnav.saturne.IdQualifiedElement;
import fr.cnav.saturne.JavaRule;
import fr.cnav.saturne.ReusedBlock;
import fr.cnav.saturne.Rule;
import fr.cnav.saturne.utils.BlockUtil;
import fr.cnav.saturne.utils.IdQualifiedElementUtil;
import fr.cnav.saturne.utils.StandardUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class RuleUtil {
    public String getRuleClassName(GenericRule rule) {
        if (rule instanceof Rule) {
            return this.getRuleClassName(rule.getFullId());
        }
        return this.getClassName(((JavaRule)rule).getRuleClass());
    }

    public String getClassName(String name) {
        return IdQualifiedElementUtil.getTagNameFromQualifiedId(name);
    }

    public String getRuleClassName(String name) {
        return "Rule" + IdQualifiedElementUtil.getTagNameFromQualifiedId(name);
    }

    public static IdQualifiedElement getActualContext(GenericRule rule) {
        IdQualifiedElement result = null;
        if (rule != null && (result = rule.getComputedContext()) == null) {
            result = RuleUtil.getActualSubject(rule);
        }
        return result;
    }

    public static IdQualifiedElement getActualSubject(GenericRule rule) {
        if (rule != null) {
            return rule.getSubject();
        }
        return null;
    }

    public Map<GenericRule, GenericRule> getDuplicateRules(List<GenericRule> rules) {
        HashMap<String, GenericRule> distinctRules = new HashMap<String, GenericRule>();
        LinkedHashMap<GenericRule, GenericRule> duplicateRules = new LinkedHashMap<GenericRule, GenericRule>();
        for (GenericRule givenRule : rules) {
            GenericRule existingRule = distinctRules.putIfAbsent(new RuleUtil().getRuleClassName(givenRule), givenRule);
            if (existingRule == null) continue;
            duplicateRules.put(givenRule, existingRule);
        }
        return duplicateRules;
    }

    public List<GenericRule> getRulesListContainedByABlock(Block block) {
        ArrayList<GenericRule> result = new ArrayList<GenericRule>();
        StandardUtil standardUtil = new StandardUtil();
        BlockUtil blockUtil = new BlockUtil();
        for (GenericRule rule : standardUtil.getStandard(block).getRules().getRules()) {
            if (!blockUtil.isInBlock(block, rule.getSubject())) continue;
            result.add(rule);
        }
        return result;
    }

    public List<GenericRule> getRulesListContainedByAField(Field field) {
        StandardUtil standardUtil = new StandardUtil();
        return standardUtil.getStandard(field).getRules().getRulesForField(field);
    }

    public List<Rule> getExcludeRulesFromDeclaration(Declaration declaration) {
        ArrayList<Rule> rulesList = new ArrayList<Rule>();
        if (declaration != null) {
            Map<Field, FieldRefinement> mapF = declaration.getFieldRefinements();
            for (Map.Entry<Field, FieldRefinement> entry : mapF.entrySet()) {
                FieldRefinement refinement = entry.getValue();
                List inhibitedRules = refinement.getInhibitedRules().stream().filter(Rule.class::isInstance).map(Rule.class::cast).collect(Collectors.toList());
                rulesList.addAll(inhibitedRules);
            }
        }
        return rulesList;
    }

    public static boolean isSubjectInReusedBlock(GenericRule rule) {
        Field subject = rule.getSubject();
        return subject.eContainer() instanceof ReusedBlock;
    }
}

