/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.types.adapter;

import fr.cnav.saturne.dsl.formules.VarRef;
import fr.cnav.saturne.dsl.parser.Logging;
import fr.cnav.saturne.dsl.types.Type;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapter;
import fr.cnav.saturne.dsl.types.adapter.ITypingEnvironment;
import java.util.Map;
import java.util.logging.Level;

public class VarRefTypeAdapter
extends DSLTypeAdapter {
    @Override
    Type computeType(Type context, Map<String, Type> env) {
        Type result;
        assert (this.getTarget() instanceof VarRef);
        String varName = ((VarRef)this.getTarget()).getVarName();
        ITypingEnvironment typingEnv = this.getTypingEnvironement();
        if (env.containsKey(varName)) {
            result = env.get(varName);
            if (result == Type.UNDEFINED) {
                this.setErrorMsg("Variable has undefined type : " + varName);
            }
        } else if (typingEnv != null && typingEnv.getNodeType(varName) != null) {
            result = typingEnv.getNodeType(varName);
            if (result == Type.UNDEFINED) {
                this.setErrorMsg("Variable has undefined type : " + varName);
            }
        } else {
            result = Type.UNDEFINED;
            this.setErrorMsg("Undefined variable type : " + varName);
        }
        if (result == Type.UNDEFINED) {
            Logging.LOGGER.log(Level.SEVERE, this.getErrorMsg());
        }
        return result;
    }
}

