/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.optimization.vn;

import fr.cnav.saturne.dsl.formules.Binary;
import fr.cnav.saturne.dsl.formules.Binding;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FieldRef;
import fr.cnav.saturne.dsl.formules.FunctionCall;
import fr.cnav.saturne.dsl.formules.In;
import fr.cnav.saturne.dsl.formules.IteratorVariable;
import fr.cnav.saturne.dsl.formules.Let;
import fr.cnav.saturne.dsl.formules.Literal;
import fr.cnav.saturne.dsl.formules.Nary;
import fr.cnav.saturne.dsl.formules.Quantified;
import fr.cnav.saturne.dsl.formules.Unary;
import fr.cnav.saturne.dsl.formules.ValueList;
import fr.cnav.saturne.dsl.formules.VarRef;
import fr.cnav.saturne.dsl.formules.util.FormulesSwitch;

public class HashedExpression {
    private static final String NO_OP_STRING = "null";
    private static final String OP_SEPARATOR = ",";
    private static final String OP_OPENER = "[";
    private static final String OP_CLOSER = "]";
    private static final BuildRepresentation REPRESENTATION_BUILDER = new BuildRepresentation();
    private String representation;
    private Expression expression;

    public HashedExpression(Expression expr) {
        this.expression = expr;
    }

    public String toString() {
        if (this.representation == null) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.expression.getClass().getName()).append(OP_OPENER);
            this.representation = (String)REPRESENTATION_BUILDER.doSwitch(this.expression);
        }
        return this.representation;
    }

    public int hashCode() {
        if (this.representation == null) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.expression.getClass().getName()).append(OP_OPENER);
            this.representation = (String)REPRESENTATION_BUILDER.doSwitch(this.expression);
        }
        return this.representation.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    static class BuildRepresentation
    extends FormulesSwitch<String> {
        BuildRepresentation() {
        }

        @Override
        public String caseBinary(Binary object) {
            StringBuilder builder = new StringBuilder();
            builder.append(object.eClass().getName());
            builder.append(HashedExpression.OP_OPENER);
            Expression leftOp = object.getLeftOp();
            if (leftOp != null) {
                builder.append(leftOp.eClass().getName());
            } else {
                builder.append(HashedExpression.NO_OP_STRING);
            }
            builder.append(HashedExpression.OP_SEPARATOR);
            Expression rightOp = object.getRightOp();
            if (rightOp != null) {
                builder.append(rightOp.eClass().getName());
            } else {
                builder.append(HashedExpression.NO_OP_STRING);
            }
            builder.append(HashedExpression.OP_CLOSER);
            return builder.toString();
        }

        @Override
        public String caseNary(Nary object) {
            StringBuilder builder = new StringBuilder();
            builder.append(object.eClass().getName());
            builder.append(HashedExpression.OP_OPENER);
            boolean first = true;
            for (Expression expr : object.getOperands()) {
                if (!first) {
                    builder.append(HashedExpression.OP_SEPARATOR);
                } else {
                    first = false;
                }
                if (expr != null) {
                    builder.append(expr.eClass().getName());
                    continue;
                }
                builder.append(HashedExpression.NO_OP_STRING);
            }
            return builder.toString();
        }

        @Override
        public String caseFunctionCall(FunctionCall object) {
            StringBuilder builder = new StringBuilder();
            builder.append("call:").append(object.getName());
            builder.append(HashedExpression.OP_OPENER);
            boolean first = true;
            for (Expression expr : object.getArguments()) {
                if (!first) {
                    builder.append(HashedExpression.OP_SEPARATOR);
                } else {
                    first = false;
                }
                if (expr != null) {
                    builder.append(expr.eClass().getName());
                    continue;
                }
                builder.append(HashedExpression.NO_OP_STRING);
            }
            return builder.toString();
        }

        @Override
        public String caseVarRef(VarRef object) {
            return object.getVarName();
        }

        @Override
        public String caseQuantified(Quantified object) {
            StringBuilder builder = new StringBuilder();
            builder.append((Object)object.getQuantifier());
            builder.append(" ");
            for (IteratorVariable variable : object.getVariables()) {
                builder.append(variable.getVarName()).append(":").append(this.fieldRefString(variable.getElement())).append(" ");
            }
            builder.append("satisfies");
            builder.append(object.getExpression().eClass().getName());
            return builder.toString();
        }

        @Override
        public String caseIn(In object) {
            StringBuilder builder = new StringBuilder();
            builder.append((String)this.doSwitch(object.getLeftOp())).append(" in ").append((String)this.doSwitch(object.getRightOp()));
            return builder.toString();
        }

        @Override
        public String caseLiteral(Literal object) {
            return object.getValue();
        }

        @Override
        public String caseValueList(ValueList object) {
            StringBuilder builder = new StringBuilder();
            builder.append(HashedExpression.OP_OPENER);
            boolean first = true;
            for (Literal literal : object.getValues()) {
                if (!first) {
                    builder.append(HashedExpression.OP_SEPARATOR);
                } else {
                    first = false;
                }
                builder.append(literal.getValue());
            }
            builder.append(HashedExpression.OP_CLOSER);
            return builder.toString();
        }

        @Override
        public String caseLet(Let object) {
            StringBuilder builder = new StringBuilder();
            builder.append("let ");
            boolean first = true;
            for (Binding binding : object.getBindings()) {
                if (!first) {
                    builder.append(";");
                } else {
                    first = false;
                }
                builder.append(binding.getVarName()).append("=").append(binding.getExpr().eClass().getName());
            }
            builder.append(" inexpr ").append(object.getIn().eClass().getName());
            return builder.toString();
        }

        private String fieldRefString(FieldRef object) {
            StringBuilder builder = new StringBuilder();
            builder.append(object.getName());
            return builder.toString();
        }

        @Override
        public String caseFieldRef(FieldRef object) {
            return this.fieldRefString(object);
        }

        @Override
        public String caseUnary(Unary object) {
            StringBuilder builder = new StringBuilder();
            builder.append(object.eClass().getName()).append(HashedExpression.OP_OPENER);
            builder.append(object.getOperand().eClass().getName());
            builder.append(HashedExpression.OP_CLOSER);
            return builder.toString();
        }
    }
}

