/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.optimization.externalize;

import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.Let;
import fr.cnav.saturne.dsl.formules.util.FormulesSwitch;
import fr.cnav.saturne.dsl.optimization.Transformation;
import fr.cnav.saturne.dsl.optimization.TransformationUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class RemoveEmptyLet
implements Transformation {
    @Override
    public Expression transform(Expression input) {
        new EmptyLetFinder().processExpr(input);
        return input;
    }

    static class EmptyLetFinder
    extends FormulesSwitch<String> {
        List<Let> killList = new ArrayList<Let>();

        EmptyLetFinder() {
        }

        void processExpr(Expression expression) {
            this.killList.clear();
            this.doSwitch(expression);
            for (Let let : this.killList) {
                TransformationUtils.substitute(let, let.getIn());
            }
        }

        @Override
        public String caseLet(Let object) {
            if (object.getBindings().size() == 0) {
                this.killList.add(object);
            }
            this.doSwitch(object.getIn());
            return "";
        }

        @Override
        public String defaultCase(EObject object) {
            for (EObject eObject : object.eContents()) {
                this.doSwitch(eObject);
            }
            return "";
        }
    }
}

