/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.common.fileselector;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class SaturneFileInPrjContainEObjModel {
    public static final String SRC_FOLDER = "%srcTag%";
    public static final String SLASH = "/";
    private String fileName;
    private String fileNameWithSrcTag;
    private String srcFolder;
    private String fileNameInClassPath;

    public SaturneFileInPrjContainEObjModel(String fileNameWithSrcTag) {
        this.fileNameWithSrcTag = fileNameWithSrcTag;
        this.fileName = fileNameWithSrcTag.replaceFirst(SRC_FOLDER, "");
        String[] filePartArrray = fileNameWithSrcTag.split(SRC_FOLDER);
        if (filePartArrray.length == 2) {
            this.srcFolder = filePartArrray[0];
            this.fileNameInClassPath = filePartArrray[1];
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getSrcFolder() {
        return this.srcFolder;
    }

    public String getFileNameInClassPath() {
        return this.fileNameInClassPath;
    }

    public String toString() {
        return this.fileNameWithSrcTag;
    }

    public File getFile() throws URISyntaxException, IOException {
        IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        File file = null;
        if (myWorkspaceRoot != null) {
            IResource resource = myWorkspaceRoot.findMember(this.fileName);
            if (resource != null && resource instanceof IFile) {
                IFile iFile = (IFile)resource;
                file = iFile.getRawLocation().toFile();
            } else {
                String[] resourceArray = this.fileName.split(SLASH);
                String bundleName = resourceArray[1];
                String resourceName = this.fileName.replaceFirst(SLASH + bundleName + SLASH, SLASH);
                Bundle bundle = Platform.getBundle((String)bundleName);
                if (bundle != null) {
                    URL fileURL = bundle.getEntry(resourceName);
                    file = fileURL != null ? new File(FileLocator.resolve((URL)fileURL).toURI()) : null;
                }
            }
        }
        return file;
    }
}

