/*
 * Decompiled with CFR 0.152.
 */
package n4ds.dsn.p03v01.all.rules;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import n4ds.dsn.p03v01.all.rules.ChaineUtil;

public class MailControleurUtil2 {
    private static final String POINT = ".";
    private static final String DOUBLE_TRAIT_UNION = "--";
    private static final String TRAIT_UNION = "-";
    private static final String UNDERSCORE = "_";
    private static final String AROBASE = "@";
    private final String msg_0 = "Pr\u00e9sence d'un ou plusieurs caract\u00e8res non autoris\u00e9s par la norme";
    private final String msg_1 = "Caract\u00e8res non autoris\u00e9s pour les adresses e-mail";
    private final String msg_2 = "L'adresse e-mail ne peut contenir un encha\u00eenement de deux caract\u00e8res point cons\u00e9cutifs";
    private final String msg_3 = "L'adresse e-mail ne peut contenir qu'un seul arobase";
    private final String msg_4 = "Les cha\u00eenes de caract\u00e8res pr\u00e9c\u00e9dents ou suivants un arobase ne peuvent commencer ou se terminer par un point, un trait d'union ou un underscore";
    private final String msg_5 = "L'adresse mail ne doit pas commencer par un arobase ou une combinaison de trait d'union, d'arobase et d'underscore";
    private final String msg_6 = "L'adresse mail ne doit pas finir par un arobase ou une combinaison de trait d'union, d'arobase et d'underscore";
    private final String msg_7 = "La cha\u00eene de caract\u00e8res suivant le caract\u00e8re arobase doit contenir au moins un point";
    private final String msg_8 = "Les adresses e-mail doivent comporter un arobase";
    private final String msg_9 = "L'adresse mail ne doit pas commencer par un point";
    private final String msg_10 = "L'adresse mail ne doit pas finir par un point";
    private final String msg_11 = "L'adresse mail ne doit pas finir par un underscore";
    private final String msg_12 = "L'adresse mail ne doit pas finir par un trait d'union";
    private final String msg_13 = "La cha\u00eene de caract\u00e8res suivant le caract\u00e8re arobase ne peut contenir le caract\u00e8re underscore";
    private ArrayList<String> tabCombinaisonPointTraitUnderscore = new ArrayList();
    private ArrayList<String> tabCombinaisonDoublePointTraitUnderscore = new ArrayList();
    private ArrayList<String> tabArobaseTraitUnderscore = new ArrayList();
    private ArrayList<String> tabPointTraitUnderscore = new ArrayList();
    private ArrayList<String> messagesRetourControle = new ArrayList();
    private boolean resultatRetourControle;

    public MailControleurUtil2() {
        this.tabCombinaisonPointTraitUnderscore.add("..");
        this.tabCombinaisonDoublePointTraitUnderscore.add(".@");
        this.tabCombinaisonDoublePointTraitUnderscore.add("-@");
        this.tabCombinaisonDoublePointTraitUnderscore.add("_@");
        this.tabCombinaisonDoublePointTraitUnderscore.add("@.");
        this.tabCombinaisonDoublePointTraitUnderscore.add("@-");
        this.tabCombinaisonDoublePointTraitUnderscore.add("@_");
        this.tabArobaseTraitUnderscore.add("_@");
        this.tabArobaseTraitUnderscore.add("@_");
        this.tabArobaseTraitUnderscore.add("_-");
        this.tabArobaseTraitUnderscore.add("-_");
        this.tabArobaseTraitUnderscore.add("-@");
        this.tabArobaseTraitUnderscore.add("@-");
        this.tabArobaseTraitUnderscore.add(AROBASE);
        this.tabPointTraitUnderscore.add(UNDERSCORE);
        this.tabPointTraitUnderscore.add(TRAIT_UNION);
        this.tabPointTraitUnderscore.add(POINT);
        this.resultatRetourControle = true;
    }

    public void controleMail(String mail) {
        if (mail != null) {
            Pattern mailPattern = Pattern.compile("[\\x21]|[\\x23-\\x25]|[\\x3b-\\x3c]|[\\x3e-\\x3f]|[\\x5b-\\x5e]|[\\x7b-\\x7e]|[\\xa0-\\xaa]|[\\xac-\\xaf]|[\\xb1-\\xba]|[\\xbc-\\xbf]|[\\xc6]|[\\xd0]|[\\xd7-\\xd8]|[\\xde-\\xdf]|[\\xe6]|[\\xf0]|[\\xf7-\\xf8]|[\\xfe]");
            Matcher mailMatcher = mailPattern.matcher(mail);
            if (mailMatcher.find()) {
                this.setResultatRetourControle(false);
                this.getMessagesRetourControle().add("Pr\u00e9sence d'un ou plusieurs caract\u00e8res non autoris\u00e9s par la norme");
            }
            if ((mailMatcher = (mailPattern = Pattern.compile("[^((\\x2d)(\\x2e)(\\x30-\\x39)(\\x61-\\x7a)(\\x40-\\x5a)(\\x5f))]")).matcher(mail)).find()) {
                this.setResultatRetourControle(false);
                this.getMessagesRetourControle().add("Caract\u00e8res non autoris\u00e9s pour les adresses e-mail");
            }
            if (!ChaineUtil.stringExistsAtPos(AROBASE, mail, "i")) {
                this.setResultatRetourControle(false);
                this.getMessagesRetourControle().add("Les adresses e-mail doivent comporter un arobase");
            }
            if (ChaineUtil.nbExemlaireSousChaineDansChaine(AROBASE, mail) != 1) {
                this.setResultatRetourControle(false);
                this.getMessagesRetourControle().add("L'adresse e-mail ne peut contenir qu'un seul arobase");
            }
            if (ChaineUtil.arrayExistsAtPos(this.tabCombinaisonPointTraitUnderscore, mail, "i")) {
                this.setResultatRetourControle(false);
                this.getMessagesRetourControle().add("L'adresse e-mail ne peut contenir un encha\u00eenement de deux caract\u00e8res point cons\u00e9cutifs");
            }
            if (ChaineUtil.arrayExistsAtPos(this.tabCombinaisonDoublePointTraitUnderscore, mail, "i") || ChaineUtil.arrayExistsAtPos(this.tabPointTraitUnderscore, mail, "P") || ChaineUtil.arrayExistsAtPos(this.tabPointTraitUnderscore, mail, "d") || MailControleurUtil2.findCharInSubstring(mail, AROBASE, UNDERSCORE)) {
                this.setResultatRetourControle(false);
                this.getMessagesRetourControle().add("Les cha\u00eenes de caract\u00e8res pr\u00e9c\u00e9dents ou suivants un arobase ne peuvent commencer ou se terminer par un point, un trait d'union ou un underscore");
            }
            if (ChaineUtil.arrayExistsAtPos(this.tabArobaseTraitUnderscore, mail, "P")) {
                this.setResultatRetourControle(false);
                this.getMessagesRetourControle().add("L'adresse mail ne doit pas commencer par un arobase ou une combinaison de trait d'union, d'arobase et d'underscore");
            }
            if (ChaineUtil.arrayExistsAtPos(this.tabArobaseTraitUnderscore, mail, "d")) {
                this.setResultatRetourControle(false);
                this.getMessagesRetourControle().add("L'adresse mail ne doit pas finir par un arobase ou une combinaison de trait d'union, d'arobase et d'underscore");
            }
            if (!ChaineUtil.sousChaineApartirDe(AROBASE, mail).contains(POINT)) {
                this.setResultatRetourControle(false);
                this.getMessagesRetourControle().add("La cha\u00eene de caract\u00e8res suivant le caract\u00e8re arobase doit contenir au moins un point");
            }
            if (ChaineUtil.stringExistsAtPos(POINT, mail, "P")) {
                this.setResultatRetourControle(false);
                this.getMessagesRetourControle().add("L'adresse mail ne doit pas commencer par un point");
            }
            if (ChaineUtil.stringExistsAtPos(POINT, mail, "d")) {
                this.setResultatRetourControle(false);
                this.getMessagesRetourControle().add("L'adresse mail ne doit pas finir par un point");
            }
            if (ChaineUtil.stringExistsAtPos(UNDERSCORE, mail, "d")) {
                this.setResultatRetourControle(false);
                this.getMessagesRetourControle().add("L'adresse mail ne doit pas finir par un underscore");
            }
            if (ChaineUtil.stringExistsAtPos(TRAIT_UNION, mail, "d")) {
                this.setResultatRetourControle(false);
                this.getMessagesRetourControle().add("L'adresse mail ne doit pas finir par un trait d'union");
            }
            if (ChaineUtil.sousChaineApartirDe(AROBASE, mail).contains(UNDERSCORE)) {
                this.setResultatRetourControle(false);
                this.getMessagesRetourControle().add("La cha\u00eene de caract\u00e8res suivant le caract\u00e8re arobase ne peut contenir le caract\u00e8re underscore");
            }
        }
    }

    public ArrayList<String> getMessagesRetourControle() {
        return this.messagesRetourControle;
    }

    public void setMessagesRetourControle(ArrayList<String> messagesRetourControle) {
        this.messagesRetourControle = messagesRetourControle;
    }

    public boolean getResultatRetourControle() {
        return this.resultatRetourControle;
    }

    public void setResultatRetourControle(boolean resultatRetourControle) {
        this.resultatRetourControle = resultatRetourControle;
    }

    public String messagesRetourControleToString() {
        String res = "";
        for (String msg : this.getMessagesRetourControle()) {
            if (this.getMessagesRetourControle().size() == 1) {
                res = res.concat(String.valueOf(msg) + POINT);
            }
            if (this.getMessagesRetourControle().size() <= 1) continue;
            res = this.getMessagesRetourControle().indexOf(msg) != this.getMessagesRetourControle().size() - 1 ? res.concat(String.valueOf(msg) + ". ") : res.concat(String.valueOf(msg) + POINT);
        }
        return res;
    }

    public static boolean findCharInSubstring(String mail, String depart, String stringToFind) {
        int i = mail.indexOf(depart);
        if (i == mail.length() || i == -1) {
            return false;
        }
        String sousChaine = mail.substring(i);
        return sousChaine.contains(stringToFind);
    }
}

