/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.metacontrol;

import fr.cnav.saturne.Standard;
import fr.cnav.saturne.dsl.formules.And;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FormulesPackage;
import fr.cnav.saturne.dsl.formules.Nary;
import fr.cnav.saturne.dsl.formules.Or;
import fr.cnav.saturne.dsl.metacontrol.AbstractTransformation;
import fr.cnav.saturne.dsl.metacontrol.Cleanup;
import fr.cnav.saturne.dsl.metacontrol.DistributionOfOrOverAnd;
import fr.cnav.saturne.dsl.metacontrol.LogicalNormalizer;
import fr.cnav.saturne.dsl.metacontrol.NotBurrying;
import fr.cnav.saturne.dsl.metacontrol.OperatorNormalizer;
import fr.cnav.saturne.dsl.metacontrol.TransformationException;
import fr.cnav.saturne.dsl.parser.ParserConfigurationException;
import java.io.IOException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class CanonicalNormalizer
extends AbstractTransformation {
    @Override
    public Expression transform(Expression expression, Standard standard) throws TransformationException {
        Expression cnfExpression = (Expression)new LogicalNormalizer().doSwitch(expression);
        try {
            cnfExpression = (Expression)new OperatorNormalizer(standard).doSwitch(cnfExpression);
        }
        catch (ParserConfigurationException e) {
            throw new TransformationException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new TransformationException(e.getMessage(), e);
        }
        cnfExpression = (Expression)new NotBurrying().doSwitch(cnfExpression);
        cnfExpression = this.distributionOfOrOverAndInDeep(cnfExpression);
        cnfExpression = (Expression)new Cleanup().doSwitch(cnfExpression);
        return cnfExpression;
    }

    private Expression distributionOfOrOverAndInDeep(Expression expr) {
        Expression expressionResult = expr;
        if (expr instanceof And) {
            if (!this.isNaryFinished((And)expr)) {
                And and = (And)EcoreUtil.create((EClass)FormulesPackage.Literals.AND);
                for (Expression operand : ((And)expr).getOperands()) {
                    Expression operandResult = (Expression)EcoreUtil.copy((EObject)operand);
                    if (operand instanceof Or || operand instanceof And) {
                        operandResult = this.distributionOfOrOverAndInDeep((Expression)EcoreUtil.copy((EObject)operand));
                    }
                    if (operandResult instanceof And) {
                        and.getOperands().addAll(((And)operandResult).getOperands());
                        continue;
                    }
                    and.getOperands().add((Object)operandResult);
                }
                expressionResult = and;
            }
        } else if (expr instanceof Or && !this.isNaryFinished((Or)expr)) {
            Or or = (Or)EcoreUtil.create((EClass)FormulesPackage.Literals.OR);
            for (Expression operand : ((Or)expr).getOperands()) {
                Expression operandResult = (Expression)EcoreUtil.copy((EObject)operand);
                if (operand instanceof Or || operand instanceof And) {
                    operandResult = this.distributionOfOrOverAndInDeep((Expression)EcoreUtil.copy((EObject)operand));
                }
                or.getOperands().add((Object)operandResult);
            }
            expressionResult = (Expression)new DistributionOfOrOverAnd().doSwitch(or);
        }
        return expressionResult;
    }

    private boolean isNaryFinished(Nary exp) {
        for (Expression operand : exp.getOperands()) {
            if (!(operand instanceof And) && !(operand instanceof Or)) continue;
            return false;
        }
        return true;
    }
}

