/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.update;

import fr.cnav.autocontrole.update.Activator;
import fr.cnav.autocontrole.update.Messages;
import fr.cnav.autocontrole.update.UpdateException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class UpdateValService {
    public static final String UPDATE_SITE_LOC_KEY = "fr.cnav.autocontrole.updatesite.loc";
    private String updateSiteURL;
    private IProvisioningAgent agent;
    private boolean initialized;

    public UpdateValService(String updateSiteURL) {
        this.updateSiteURL = updateSiteURL;
    }

    private void initP2Agent() throws ProvisionException, UpdateException {
        BundleContext bundleContext = Activator.getDefault().getContext().getBundle().getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(IProvisioningAgent.class);
        this.agent = (IProvisioningAgent)bundleContext.getService(serviceReference);
        if (this.agent == null) {
            throw new UpdateException(6);
        }
        this.initialized = true;
    }

    private UpdateOperation prepareOperation() throws UpdateException {
        if (!this.initialized) {
            try {
                this.initP2Agent();
            }
            catch (ProvisionException e) {
                throw new UpdateException(2, (Throwable)e);
            }
        }
        ProvisioningSession session = new ProvisioningSession(this.agent);
        UpdateOperation operation = new UpdateOperation(session);
        URI uri = null;
        if (this.updateSiteURL == null) {
            throw new UpdateException(0, Messages.UndefinedURI_0);
        }
        try {
            uri = new URI(this.updateSiteURL);
        }
        catch (URISyntaxException e) {
            throw new UpdateException(4, String.valueOf(Messages.IncorrectURI_0) + this.updateSiteURL, e);
        }
        operation.getProvisioningContext().setArtifactRepositories(new URI[]{uri});
        operation.getProvisioningContext().setMetadataRepositories(new URI[]{uri});
        return operation;
    }

    public boolean checkForUpdate(IProgressMonitor monitor) throws UpdateException {
        try {
            this.getUpdateJob(monitor);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UpdateException(1);
        }
        return this.getUpdateJob(monitor) != null;
    }

    public Job getUpdateJob(IProgressMonitor monitor) throws UpdateException {
        SubMonitor sub;
        UpdateOperation operation = this.prepareOperation();
        IStatus status = operation.resolveModal((IProgressMonitor)(sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.InstallingUpdate_0, (int)200)));
        if (status.getCode() != 10000) {
            return operation.getProvisioningJob(monitor);
        }
        return null;
    }

    public IStatus update(IProgressMonitor monitor) throws UpdateException {
        SubMonitor sub;
        UpdateOperation operation = this.prepareOperation();
        IStatus status = operation.resolveModal((IProgressMonitor)(sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.InstallingUpdate_0, (int)200)));
        if (status.getCode() != 10000) {
            ProvisioningJob job = operation.getProvisioningJob(monitor);
            if (job != null) {
                return job.runModal((IProgressMonitor)sub.newChild(100));
            }
            return new Status(4, "fr.cnav.autocontrole.update", Messages.ProblemWithUpdate_0);
        }
        return status;
    }
}

