/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.syntax;

import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.engine.IRule;
import fr.cnav.saturne.validator.engine.IRuleResult;
import fr.cnav.saturne.validator.engine.RuleFailure;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.syntax.AbstractFieldSyntaxControl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Csl00SyntaxControl
extends AbstractFieldSyntaxControl {
    private final String regexp;
    private final String fullQualifiedId;

    public Csl00SyntaxControl(int id, String code, FieldDescription target, String fullQualifiedId, String regexp, ControlMessages controlMessage, DeclarationDescription declaration) {
        super(id, code, target, controlMessage, declaration);
        this.regexp = regexp;
        this.fullQualifiedId = fullQualifiedId;
    }

    @Override
    public List<FieldDescription> getUsedData() {
        if (this.getTarget() instanceof FieldDescription) {
            return Stream.of((FieldDescription)this.getTarget()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        return new ArrayList<FieldDescription>();
    }

    @Override
    public IRuleResult run(IMessageField<?> subject) {
        IRuleResult result = IRule.SUCCESS;
        String value = subject.getValueAsString();
        if (value != null && !"".equals(subject.getValueAsString())) {
            Pattern regexpPattern = Pattern.compile(this.regexp);
            Matcher valueMatcher = regexpPattern.matcher(value);
            boolean matches = valueMatcher.matches();
            if (matches) {
                result = IRule.SUCCESS;
            } else {
                String message = this.controlMessage.getMessage("syntactic.messages.CSL00", new Object[]{this.fullQualifiedId});
                RuleFailure resultFailure = new RuleFailure(this, subject, subject.getParent(), message);
                result = resultFailure;
            }
        }
        return result;
    }
}

