/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.positional.csv.importer;

import fr.cnav.saturne.Field;
import fr.cnav.saturne.ModelAccessor;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.validator.positional.csv.CsvInfo;
import fr.cnav.saturne.validator.positional.csv.CsvProblemSeverity;
import fr.cnav.saturne.validator.positional.csv.IValidationRule;
import fr.cnav.saturne.validator.positional.csv.importer.PositionalFixModelCSVMapping;

public class FieldPositionalMappingRule
implements IValidationRule {
    private static final String MESSAGE_NO_CORRESPONDING_FIELD_IN_NORM = "The field with the given full qualified id does not exist in the norm. Please fix it to be able to continue import.";
    private int fieldIdColumnRank;
    private ModelAccessor modelAccessor;

    public FieldPositionalMappingRule(int fieldIdColumnRank, Standard theStandard) {
        if (theStandard == null) {
            throw new IllegalArgumentException("the Standard cannot be null.");
        }
        this.fieldIdColumnRank = fieldIdColumnRank;
        this.modelAccessor = new ModelAccessor(theStandard);
    }

    @Override
    public CsvInfo validate(String[] line) {
        Field field;
        String fieldFullQualifiedId = null;
        if (line != null && this.fieldIdColumnRank < line.length) {
            fieldFullQualifiedId = line[this.fieldIdColumnRank];
        }
        if (fieldFullQualifiedId != null && !fieldFullQualifiedId.isEmpty() && (field = this.modelAccessor.getField(fieldFullQualifiedId)) == null) {
            return new CsvInfo(CsvProblemSeverity.FATAL, PositionalFixModelCSVMapping.TITLES.get(this.fieldIdColumnRank), String.format(MESSAGE_NO_CORRESPONDING_FIELD_IN_NORM + fieldFullQualifiedId, new Object[0]));
        }
        return null;
    }
}

