/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.positional.conversion;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.NatureType;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.validator.ITreeAndDeclarationConsumer;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.conversion.ConversionSerializationException;
import fr.cnav.saturne.validator.impl.ValidatorEncodingHandler;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.message.api.IMessageFieldAlphanum;
import fr.cnav.saturne.validator.message.api.IMessageFieldDate;
import fr.cnav.saturne.validator.message.api.IMessageFieldNum;
import fr.cnav.saturne.validator.positional.FieldSpecification;
import fr.cnav.saturne.validator.positional.FooterSpecification;
import fr.cnav.saturne.validator.positional.FormatSpecification;
import fr.cnav.saturne.validator.positional.HeaderSpecification;
import fr.cnav.saturne.validator.positional.RecordIdSpecification;
import fr.cnav.saturne.validator.positional.RecordSpecification;
import fr.cnav.saturne.validator.positional.conversion.PositionalFixPadding;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionalFixSerializer
implements ITreeAndDeclarationConsumer {
    protected static final Logger LOGGER = LoggerFactory.getLogger(PositionalFixSerializer.class);
    protected final FormatSpecification formatSpecification;
    protected final Writer writer;
    protected int lineNumber;
    protected final PositionalFixPadding positionalFixPadding = new PositionalFixPadding();
    private final String encoding;

    public PositionalFixSerializer(Standard theStandard, FormatSpecification theFormatSpecification, OutputStream outputStream, String encoding) throws ConversionSerializationException {
        this.formatSpecification = theFormatSpecification;
        if (theStandard == null) {
            throw new IllegalArgumentException("The standard should not be null. The serialization will not be realized.");
        }
        if (theStandard.getNamespacePrefix() == null) {
            throw new IllegalArgumentException("The standard namespace prefix should not be null. The serialization will not be realized.");
        }
        if (theStandard.getNameSpace() == null) {
            throw new IllegalArgumentException("The standard namespace should not be null. The serialization will not be realized.");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("The encoding should not be null. The serialization will not be realized.");
        }
        if (theFormatSpecification == null) {
            throw new IllegalArgumentException("The positionalFix configuration model should not be null. The serialization will not be realized.");
        }
        ValidatorEncodingHandler validatorEncodingHandler = new ValidatorEncodingHandler();
        if (outputStream == null) {
            throw new IllegalArgumentException("The output stream should not be null. The serialization will not be realized.");
        }
        Charset charset = validatorEncodingHandler.getEncodingToUse(encoding, theStandard);
        this.writer = new OutputStreamWriter(outputStream, charset);
        this.encoding = charset.toString();
    }

    public PositionalFixSerializer(Standard theStandard, FormatSpecification theFormatSpecification, Writer parent, String encoding) throws ConversionSerializationException {
        this.formatSpecification = theFormatSpecification;
        if (theStandard == null) {
            throw new IllegalArgumentException("The standard should not be null. The serialization will not be realized.");
        }
        if (theStandard.getNamespacePrefix() == null) {
            throw new IllegalArgumentException("The standard namespace prefix should not be null. The serialization will not be realized.");
        }
        if (theStandard.getNameSpace() == null) {
            throw new IllegalArgumentException("The standard namespace should not be null. The serialization will not be realized.");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("The encoding should not be null. The serialization will not be realized.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("The writer should not be null. The serialization will not be realized.");
        }
        if (theFormatSpecification == null) {
            throw new IllegalArgumentException("The positionalFix configuration model should not be null. The serialization will not be realized.");
        }
        ValidatorEncodingHandler validatorEncodingHandler = new ValidatorEncodingHandler();
        Charset charset = validatorEncodingHandler.getEncodingToUse(encoding, theStandard);
        this.writer = parent;
        this.encoding = charset.toString();
    }

    @Override
    public void startTree() throws TreeProcessingException {
    }

    @Override
    public void endTree() throws TreeProcessingException {
        try {
            this.writer.flush();
        }
        catch (IOException exception) {
            throw new TreeProcessingException("An exception has occured while appending the footer of the converted file: " + exception.getMessage(), exception);
        }
    }

    @Override
    public void enterBlock(IMessageBlock block) throws TreeProcessingException {
        if (block.getStandardBlockDescription() instanceof BlockDescription) {
            RecordSpecification currentRecordSpecification = null;
            for (RecordSpecification recordSpecification : this.formatSpecification.getRecords()) {
                if (!recordSpecification.getBlock().getId().equals(block.getStandardBlockDescription().getFullQualifiedId())) continue;
                currentRecordSpecification = recordSpecification;
            }
            if (currentRecordSpecification == null && !this.blockIsInHeaderOrFooterPxfBlock(block)) {
                throw new TreeProcessingException("The Block " + block.getStandardBlockDescription().getFullQualifiedId() + " has no RecordSpecification and it is not a Header or Footer Block so we can not serialize it.");
            }
            if (currentRecordSpecification != null) {
                StringBuffer currentLine = this.getCurrentline(block, currentRecordSpecification);
                if (this.formatSpecification.getIdExtractorClassName() == null || "".equals(this.formatSpecification.getIdExtractorClassName().trim())) {
                    for (RecordIdSpecification recordIdSpecification : this.formatSpecification.getIdSpecifications()) {
                        String idValue = block.getStandardBlockDescription().getFullQualifiedId();
                        currentLine = currentLine.replace(recordIdSpecification.getRecordTypeStartPosition() - 1, recordIdSpecification.getRecordTypeStartPosition() - 1 + idValue.length(), idValue);
                    }
                }
                ++this.lineNumber;
                this.writeFieldsOfBlock(block, currentRecordSpecification, currentLine);
                try {
                    this.writer.append(currentLine);
                    String endRecordDelimiter = this.formatSpecification.getEndRecordDelimiter();
                    if (endRecordDelimiter == null || "".equals(endRecordDelimiter)) {
                        endRecordDelimiter = "\n";
                    }
                    this.writer.append(endRecordDelimiter);
                }
                catch (IOException e) {
                    throw new TreeProcessingException(e);
                }
            }
        }
    }

    protected boolean blockIsInHeaderOrFooterPxfBlock(IMessageBlock blockMessage) {
        Block blockParent;
        EObject fieldParent;
        Boolean result = false;
        for (HeaderSpecification headerSpecification : this.formatSpecification.getHeaderSpecifications()) {
            fieldParent = headerSpecification.getField().eContainer();
            if (!(fieldParent instanceof Block) || !(blockParent = (Block)fieldParent).getFullQualifiedId().equals(blockMessage.getStandardBlockDescription().getFullQualifiedId())) continue;
            return true;
        }
        for (FooterSpecification footerSpecification : this.formatSpecification.getFooterSpecifications()) {
            fieldParent = footerSpecification.getField().eContainer();
            if (!(fieldParent instanceof Block) || !(blockParent = (Block)fieldParent).getFullQualifiedId().equals(blockMessage.getStandardBlockDescription().getFullQualifiedId())) continue;
            return true;
        }
        return result;
    }

    private void writeFieldsOfBlock(IMessageBlock block, RecordSpecification currentRecordSpecification, StringBuffer currentLine) {
        List fields = ((BlockDescription)block.getStandardBlockDescription()).getFields();
        int i = 0;
        while (i < fields.size()) {
            FieldDescription field = (FieldDescription)fields.get(i);
            FieldSpecification fieldSpecification = this.getFieldRecord(field, currentRecordSpecification);
            IMessageField<?> msgField = block.getField(i);
            if (msgField != null) {
                this.writeMessageFieldValue(currentLine, fieldSpecification, msgField);
            } else {
                this.writeMessageEmptyFieldValue(currentLine, fieldSpecification);
            }
            ++i;
        }
    }

    protected void writeMessageEmptyFieldValue(StringBuffer currentLine, FieldSpecification fieldSpecification) {
        String fieldValue = "";
        NatureType nature = fieldSpecification.getField().getDataType().getNature();
        int pxfSpecFieldSize = fieldSpecification.getEndPosition() - fieldSpecification.getStartPosition() + 1;
        fieldValue = this.positionalFixPadding.paddingEmptyValue(pxfSpecFieldSize, nature);
        currentLine.replace(fieldSpecification.getStartPosition() - 1, fieldSpecification.getEndPosition(), fieldValue);
    }

    protected void writeMessageFieldValue(StringBuffer currentLine, FieldSpecification fieldSpecification, IMessageField<?> msgField) {
        String fieldValue = msgField.getOriginalValueAsString();
        int positionLength = fieldSpecification.getEndPosition() - fieldSpecification.getStartPosition() + 1;
        NatureType nature = msgField.getStandardFieldDescription().getDataType().getNature();
        if (fieldValue != null) {
            if (fieldValue.length() > positionLength) {
                LOGGER.warn("The given field value " + fieldValue + " of field " + fieldSpecification.getField().getFullQualifiedId() + " has a size too large compare to PFX positions in line " + this.lineNumber + " (" + positionLength + " characters from " + fieldSpecification.getStartPosition() + " to " + fieldSpecification.getEndPosition() + ").");
                currentLine.replace(fieldSpecification.getStartPosition() - 1, fieldSpecification.getEndPosition(), fieldValue.substring(0, positionLength));
            } else {
                fieldValue = this.positionalFixPadding.padding(fieldValue, positionLength, nature);
                currentLine.replace(fieldSpecification.getStartPosition() - 1, fieldSpecification.getEndPosition(), fieldValue);
            }
        } else {
            this.writeMessageEmptyFieldValue(currentLine, fieldSpecification);
        }
    }

    protected FieldSpecification getFieldRecord(FieldDescription field, RecordSpecification recordSpecification) {
        for (FieldSpecification fieldSpecification : recordSpecification.getFields()) {
            if (field.getFullQualifiedId() == null || !field.getFullQualifiedId().equals(fieldSpecification.getField().getFullQualifiedId())) continue;
            return fieldSpecification;
        }
        return null;
    }

    protected StringBuffer getCurrentline(IMessageBlock block, RecordSpecification recordSpecification) {
        int lineSize = recordSpecification.getRecordLength();
        if (lineSize == -1) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < lineSize) {
            result.append(this.formatSpecification.getTrimmingCharacter());
            ++i;
        }
        return result;
    }

    @Override
    public void exitBlock(IMessageBlock block) throws TreeProcessingException {
    }

    @Override
    public void signalAlphanumField(IMessageFieldAlphanum field) throws TreeProcessingException {
    }

    @Override
    public void signalNumericField(IMessageFieldNum field) throws TreeProcessingException {
    }

    @Override
    public void signalDateField(IMessageFieldDate field) throws TreeProcessingException {
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void signalDeclaration(IMessageBlock block, DeclarationDescription declaration) throws TreeProcessingException {
    }
}

