/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.positional.conversion;

import fr.cnav.saturne.SaturnePackage;
import fr.cnav.saturne.util.SaturneResourceFactoryImpl;
import fr.cnav.saturne.validator.SaturneValidatorException;
import fr.cnav.saturne.validator.positional.FormatSpecification;
import fr.cnav.saturne.validator.positional.PositionalPackage;
import fr.cnav.saturne.validator.positional.util.PositionalResourceFactoryImpl;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class ModelPositionalLoader {
    public static final String MAIN_FILE_EXTENSION = "positional";
    private static final String NATURE_ERROR_MESSAGE = "The specified resource doens't contain a Positional model.";
    private static final String URL_ERROR_MESSAGE = "The specified resource should have a non null url.";
    private static final String FILE_ERROR_MESSAGE = "The specified file resource is non null or not found.";
    private FormatSpecification positional;

    public ModelPositionalLoader(URL url) throws SaturneValidatorException {
        if (url == null) {
            throw new SaturneValidatorException(URL_ERROR_MESSAGE);
        }
        try {
            ResourceSet rs = this.createResourceSet();
            Resource resource = this.loadModel(rs, url);
            this.initializeModel(resource);
        }
        catch (IOException e) {
            throw new SaturneValidatorException(e);
        }
        catch (URISyntaxException e) {
            throw new SaturneValidatorException(e);
        }
        catch (IllegalArgumentException e) {
            throw new SaturneValidatorException(e);
        }
    }

    public ModelPositionalLoader(ResourceSet rs, URL url) throws SaturneValidatorException {
        if (url == null) {
            throw new SaturneValidatorException(URL_ERROR_MESSAGE);
        }
        try {
            this.initResourceSetWithPFX(rs);
            this.initResourceSetWithSaturne(rs);
            Resource resource = this.loadModel(rs, url);
            this.initializeModel(resource);
        }
        catch (IOException e) {
            throw new SaturneValidatorException(e);
        }
        catch (URISyntaxException e) {
            throw new SaturneValidatorException(e);
        }
        catch (IllegalArgumentException e) {
            throw new SaturneValidatorException(e);
        }
    }

    public ModelPositionalLoader(File modelFile) throws SaturneValidatorException {
        if (modelFile == null || !modelFile.exists()) {
            throw new SaturneValidatorException(FILE_ERROR_MESSAGE);
        }
        try {
            ResourceSet rs = this.createResourceSet();
            Resource resource = this.loadModel(rs, modelFile);
            this.initializeModel(resource);
        }
        catch (IOException e) {
            throw new SaturneValidatorException(e);
        }
        catch (IllegalArgumentException e) {
            throw new SaturneValidatorException(e);
        }
    }

    private void initializeModel(Resource resource) {
        if (resource.getContents().size() > 0) {
            EObject content = (EObject)resource.getContents().get(0);
            if (content instanceof FormatSpecification) {
                this.positional = (FormatSpecification)content;
            } else {
                throw new IllegalArgumentException(NATURE_ERROR_MESSAGE);
            }
        }
    }

    private ResourceSet createResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.initResourceSetWithSaturne((ResourceSet)resourceSet);
        this.initResourceSetWithPFX((ResourceSet)resourceSet);
        return resourceSet;
    }

    private void initResourceSetWithSaturne(ResourceSet resourceSet) {
        if (!resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().containsKey("saturne")) {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("saturne", new SaturneResourceFactoryImpl());
        }
        if (resourceSet.getPackageRegistry().get((Object)"http://www.cnav.fr/saturne/1.0") == null) {
            resourceSet.getPackageRegistry().put((Object)"http://www.cnav.fr/saturne/1.0", (Object)SaturnePackage.eINSTANCE);
        }
    }

    private void initResourceSetWithPFX(ResourceSet resourceSet) {
        if (!resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().containsKey(MAIN_FILE_EXTENSION)) {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(MAIN_FILE_EXTENSION, new PositionalResourceFactoryImpl());
        }
        if (resourceSet.getPackageRegistry().get((Object)"http://www.cnav.fr/saturne/positional/1.0") == null) {
            resourceSet.getPackageRegistry().put((Object)"http://www.cnav.fr/saturne/positional/1.0", (Object)PositionalPackage.eINSTANCE);
        }
    }

    private Resource loadModel(ResourceSet rs, File file) throws IOException {
        Resource resource = rs.getResource(URI.createFileURI((String)file.getAbsolutePath()), true);
        resource.load(Collections.EMPTY_MAP);
        return resource;
    }

    private Resource loadModel(ResourceSet rs, URL url) throws IOException, URISyntaxException {
        URI uri = URI.createURI((String)url.toURI().toString());
        Resource resource = rs.getResource(uri, true);
        resource.load(Collections.EMPTY_MAP);
        return resource;
    }

    public FormatSpecification getPositional() {
        return this.positional;
    }
}

