/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.message;

import fr.cnav.saturne.api.model.access.HeaderBlockDescription;
import fr.cnav.saturne.api.model.access.MessageDescription;
import fr.cnav.saturne.api.model.access.MessageElementDescription;
import fr.cnav.saturne.validator.message.MessageAccessException;
import fr.cnav.saturne.validator.message.MessageElement;
import fr.cnav.saturne.validator.message.MessageField;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MessageBlock
extends MessageElement
implements IMessageBlock {
    private final MessageElementDescription standardElementDescription;
    private final List<IMessageField<?>> fields;
    private final List<List<IMessageBlock>> children;
    private final int index;
    private IMessageField<?> firstLeafField;
    private int firstLine = -1;
    private IMessageField<?> lastField;

    public MessageBlock(MessageElementDescription theStandardElement, int index, int fieldNumber, int childrenNumber) {
        this.standardElementDescription = theStandardElement;
        this.index = index;
        this.fields = new ArrayList(fieldNumber);
        int i = 0;
        while (i < fieldNumber) {
            this.fields.add(null);
            ++i;
        }
        this.children = new ArrayList<List<IMessageBlock>>(childrenNumber);
        i = 0;
        while (i < childrenNumber) {
            this.children.add(new ArrayList());
            ++i;
        }
    }

    @Override
    public IMessageField<?> getField(int idx) {
        try {
            return this.fields.get(idx);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public List<IMessageBlock> getBlock(int idx) {
        try {
            return this.children.get(idx);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new MessageAccessException("Unknown block id in " + this.standardElementDescription.getFullQualifiedId() + " : " + idx);
        }
    }

    @Override
    public void addField(IMessageField<?> messageField) {
        this.fields.set(messageField.getIndex(), messageField);
        ((MessageField)messageField).setParent(this);
        this.setFirstLeadField(messageField);
        this.setLastField(messageField);
    }

    @Override
    public void eraseField(int idx) {
        IMessageField<?> field = this.fields.get(idx);
        if (field != null && field != this.firstLeafField) {
            this.fields.set(idx, null);
        }
    }

    @Override
    public void eraseBlock(int idx) {
        List<IMessageBlock> blocks = this.children.get(idx);
        if (blocks != null) {
            this.children.set(idx, null);
        }
    }

    @Override
    public void addBlock(IMessageBlock newMessageblock) {
        IMessageField<?> newBlockLastField;
        int newBlockIndex = this.standardElementDescription instanceof MessageDescription ? (newMessageblock.getStandardBlockDescription() instanceof HeaderBlockDescription ? 0 : 1) : newMessageblock.getIndex();
        this.children.get(newBlockIndex).add(newMessageblock);
        ((MessageBlock)newMessageblock).setParent(this);
        IMessageField<?> leaf = newMessageblock.getFirstLeafField();
        if (leaf != null) {
            this.setFirstLeadField(leaf);
        }
        if ((newBlockLastField = newMessageblock.getLastField()) != null) {
            this.setLastField(newBlockLastField);
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public MessageElementDescription getStandardBlockDescription() {
        return this.standardElementDescription;
    }

    @Override
    public List<IMessageField<?>> getFields() {
        ArrayList result = new ArrayList(this.fields.size());
        int fieldSize = this.fields.size();
        int i = 0;
        while (i < fieldSize) {
            IMessageField<?> field = this.fields.get(i);
            if (field != null) {
                result.add(field);
            }
            ++i;
        }
        return result;
    }

    @Override
    public int getAllFieldsSize() {
        return this.fields.size();
    }

    @Override
    public List<List<IMessageBlock>> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public int getFirstLine() {
        int result = this.firstLine != -1 ? this.firstLine : (this.firstLeafField != null ? this.firstLeafField.getFieldLocalizer().getLineNumber() : -1);
        return result;
    }

    @Override
    public int getLastLine() {
        int result = this.lastField != null ? this.lastField.getFieldLocalizer().getLineNumber() : this.firstLine;
        return result;
    }

    private void setFirstLeadField(IMessageField<?> leaf) {
        if (leaf != null && (this.firstLeafField == null || leaf.getFieldLocalizer().getLineNumber() < this.firstLeafField.getFieldLocalizer().getLineNumber())) {
            this.firstLeafField = leaf;
            MessageBlock parent = (MessageBlock)this.getParent();
            if (parent != null) {
                parent.setFirstLeadField(leaf);
            }
        }
    }

    @Override
    public IMessageField<?> getFirstLeafField() {
        return this.firstLeafField;
    }

    private void setLastField(IMessageField<?> leaf) {
        if (this.lastField == null || leaf.getFieldLocalizer().getLineNumber() > this.lastField.getFieldLocalizer().getLineNumber()) {
            this.lastField = leaf;
            MessageBlock parent = (MessageBlock)this.getParent();
            if (parent != null) {
                parent.setLastField(leaf);
            }
        }
    }

    @Override
    public IMessageField<?> getLastField() {
        return this.lastField;
    }

    @Override
    public void setFirstLine(int firstLine) {
        this.firstLine = firstLine;
    }

    public String toString() {
        return "MessageBlock [standardElement=" + this.standardElementDescription.getFullQualifiedId() + "]";
    }
}

