/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FormatType implements Enumerator
{
    TXT(1, "TXT", "TXT"),
    TXTNP(2, "TXTNP", "TXTNP"),
    XML(3, "XML", "XML"),
    XMLNP(4, "XMLNP", "XMLNP"),
    CSV(5, "CSV", "CSV"),
    CSVNP(6, "CSVNP", "CSVNP"),
    PFX(7, "PFX", "PFX"),
    JSON(8, "JSON", "JSON");

    public static final int TXT_VALUE = 1;
    public static final int TXTNP_VALUE = 2;
    public static final int XML_VALUE = 3;
    public static final int XMLNP_VALUE = 4;
    public static final int CSV_VALUE = 5;
    public static final int CSVNP_VALUE = 6;
    public static final int PFX_VALUE = 7;
    public static final int JSON_VALUE = 8;
    private static final FormatType[] VALUES_ARRAY;
    public static final List<FormatType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FormatType[]{TXT, TXTNP, XML, XMLNP, CSV, CSVNP, PFX, JSON};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FormatType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FormatType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FormatType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FormatType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FormatType get(int value) {
        switch (value) {
            case 1: {
                return TXT;
            }
            case 2: {
                return TXTNP;
            }
            case 3: {
                return XML;
            }
            case 4: {
                return XMLNP;
            }
            case 5: {
                return CSV;
            }
            case 6: {
                return CSVNP;
            }
            case 7: {
                return PFX;
            }
            case 8: {
                return JSON;
            }
        }
        return null;
    }

    private FormatType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

