/*
 * Decompiled with CFR 0.152.
 */
package n4ds.dsn.serializer.html.exporter.parser;

import java.text.MessageFormat;
import java.util.List;
import java.util.TreeMap;
import n4ds.dsn.serializer.html.exporter.parser.AbstractDSNParser;

public abstract class MessageFormatParser
extends AbstractDSNParser {
    private TreeMap<Integer, Object> intToValueHeader = new TreeMap();
    private TreeMap<Integer, Object> intToValueBody = new TreeMap();
    private TreeMap<Integer, Object> intToValueFooter = new TreeMap();

    public MessageFormatParser(List<String> templates) {
        super(templates);
    }

    public MessageFormatParser(List<String> templates, TreeMap<Integer, Object> intToValueHeader, TreeMap<Integer, Object> intToValueBody, TreeMap<Integer, Object> intToValueFooter) {
        this(templates);
        if (intToValueHeader != null) {
            this.intToValueHeader = intToValueHeader;
        }
        if (intToValueBody != null) {
            this.intToValueBody = intToValueBody;
        }
        if (intToValueFooter != null) {
            this.intToValueFooter = intToValueFooter;
        }
    }

    @Override
    protected String printBody(String result) {
        if (this.intToValueBody.isEmpty()) {
            return String.valueOf(result) + this.getBody();
        }
        String format = MessageFormat.format(this.getBody(), this.intToValueBody.values().toArray());
        return result.concat(format);
    }

    @Override
    protected String printHeader(String result) {
        if (this.intToValueHeader.isEmpty()) {
            return String.valueOf(result) + this.getHeader();
        }
        String format = MessageFormat.format(this.getHeader(), this.intToValueHeader.values().toArray());
        return result.concat(format);
    }

    @Override
    protected String printFooter(String result) {
        if (this.intToValueFooter.isEmpty()) {
            return String.valueOf(result) + this.getFooter();
        }
        String format = MessageFormat.format(this.getHeader(), this.intToValueFooter.values().toArray());
        return result.concat(format);
    }

    public TreeMap<Integer, Object> getIntToValueHeader() {
        return this.intToValueHeader;
    }

    public void setIntToValueHeader(TreeMap<Integer, Object> intToValueHeader) {
        this.intToValueHeader = intToValueHeader;
    }

    public TreeMap<Integer, Object> getIntToValueBody() {
        return this.intToValueBody;
    }

    public void setIntToValueBody(TreeMap<Integer, Object> intToValueBody) {
        this.intToValueBody = intToValueBody;
    }

    public TreeMap<Integer, Object> getIntToValueFooter() {
        return this.intToValueFooter;
    }

    public void setIntToValueFooter(TreeMap<Integer, Object> intToValueFooter) {
        this.intToValueFooter = intToValueFooter;
    }
}

