/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.ui.views;

import fr.cnav.autocontrole.helpers.StandardHelper;
import fr.cnav.autocontrole.ui.Messages;
import fr.cnav.saturne.options.Key;
import java.io.File;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class OpenMessageWizardPage
extends WizardPage {
    private static final int DEFAULT_EXT = 0;
    final FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
    private Text textFile;
    private static final int selectedIndex = 0;
    private String defaultFolder;

    public String getDefaultFolder() {
        return this.defaultFolder;
    }

    public void setDefaultFolder(String defaultFolder) {
        this.defaultFolder = defaultFolder;
    }

    public OpenMessageWizardPage() {
        super("wizardPage");
        this.setTitle(Messages.OpenMessageWizardPage_1);
        this.setDescription(Messages.OpenMessageWizardPage_2);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblFichier = new Label(container, 0);
        lblFichier.setText(Messages.OpenMessageWizardPage_3);
        Composite compositeFile = new Composite(container, 0);
        compositeFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        compositeFile.setLayout((Layout)new GridLayout(3, false));
        this.textFile = new Text(compositeFile, 2048);
        this.textFile.setEditable(false);
        this.textFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnBrowse = new Button(compositeFile, 0);
        btnBrowse.setText(Messages.ExportWizardPage_8);
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OpenMessageWizardPage.this.handleBrowseButtonPressed();
            }
        });
        this.fileDialog.setFilterIndex(0);
    }

    protected void handleBrowseButtonPressed() {
        String selectedFileName;
        List extensions = (List)StandardHelper.getInstance().getNormDescriptor().getOptions().getOption(new Key("fr.cnav.saturne.validator.inputExtensionValidation"));
        String[] filterExt = null;
        int index = 0;
        if (extensions != null) {
            filterExt = new String[extensions.size() + 2];
            for (String ext : extensions) {
                filterExt[index] = String.format(Messages.OpenHandler_2, ext);
                ++index;
            }
        } else {
            filterExt = new String[2];
        }
        filterExt[index] = Messages.OpenHandler_9;
        filterExt[++index] = Messages.OpenHandler_3;
        this.fileDialog.setFilterExtensions(filterExt);
        this.fileDialog.setFilterPath(this.defaultFolder);
        this.fileDialog.setText(Messages.OpenMessageWizardPage_1);
        String currentSourceString = this.textFile.getText();
        File file = new File(this.textFile.getText());
        if (file.isFile()) {
            int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
            if (lastSeparatorIndex != -1) {
                this.fileDialog.setFileName(currentSourceString.substring(lastSeparatorIndex + 1, currentSourceString.length()));
            }
        } else {
            this.fileDialog.setFileName(currentSourceString);
        }
        if ((selectedFileName = this.fileDialog.open()) != null) {
            this.textFile.setText(selectedFileName);
        }
    }

    public String getFile() {
        if (this.textFile != null) {
            return this.textFile.getText();
        }
        return "";
    }
}

