/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.provider;

import fr.cnav.saturne.BlockRefinement;
import fr.cnav.saturne.FieldRefinement;
import fr.cnav.saturne.IdQualifiedElement;
import fr.cnav.saturne.Refinement;
import fr.cnav.saturne.SaturnePackage;
import fr.cnav.saturne.UsageType;
import fr.cnav.saturne.provider.SaturneEditPlugin;
import fr.cnav.saturne.utils.RuleUtil;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class RefinementItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public RefinementItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addUsagePropertyDescriptor(object);
            this.addInhibitedRulesPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addUsagePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Refinement_usage_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Refinement_usage_feature", "_UI_Refinement_type"), (EStructuralFeature)SaturnePackage.Literals.REFINEMENT__USAGE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addInhibitedRulesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Refinement_inhibitedRules_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Refinement_inhibitedRules_feature", "_UI_Refinement_type"), (EStructuralFeature)SaturnePackage.Literals.REFINEMENT__INHIBITED_RULES, true, false, false, null, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                UniqueEList results = new UniqueEList();
                if (object instanceof BlockRefinement) {
                    RuleUtil ruleUtil = new RuleUtil();
                    BlockRefinement blockRefinement = (BlockRefinement)object;
                    if (blockRefinement.getBlock() != null) {
                        return ruleUtil.getRulesListContainedByABlock(blockRefinement.getBlock());
                    }
                } else if (object instanceof FieldRefinement) {
                    FieldRefinement fieldRefinement = (FieldRefinement)object;
                    RuleUtil ruleUtil = new RuleUtil();
                    if (fieldRefinement.getField() != null) {
                        return ruleUtil.getRulesListContainedByAField(fieldRefinement.getField());
                    }
                }
                return results;
            }

            public IItemLabelProvider getLabelProvider(Object object) {
                return new ItemPropertyDescriptor.ItemDelegator(this, RefinementItemProvider.this.getRootAdapterFactory(), RefinementItemProvider.this.getResourceLocator()){

                    public String getText(Object object) {
                        if (object instanceof IdQualifiedElement) {
                            return String.valueOf(((IdQualifiedElement)object).getFullQualifiedId()) + " - " + ((IdQualifiedElement)object).getName();
                        }
                        return super.getText(object);
                    }
                };
            }
        });
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Refinement"));
    }

    public String getText(Object object) {
        UsageType labelValue = ((Refinement)object).getUsage();
        String label = labelValue == null ? null : labelValue.toString();
        return label == null || label.length() == 0 ? this.getString("_UI_Refinement_type") : String.valueOf(this.getString("_UI_Refinement_type")) + " " + label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Refinement.class)) {
            case 0: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return SaturneEditPlugin.INSTANCE;
    }
}

